// Copyright (C) 2014 Arthur I. Schwarz
//
// This file is part of the C++ SLIP library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.

// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer Slip_create_buffer
#define yy_delete_buffer Slip_delete_buffer
#define yy_flex_debug Slip_flex_debug
#define yy_init_buffer Slip_init_buffer
#define yy_flush_buffer Slip_flush_buffer
#define yy_load_buffer_state Slip_load_buffer_state
#define yy_switch_to_buffer Slip_switch_to_buffer
#define yyin Slipin
#define yyleng Slipleng
#define yylex Sliplex
#define yylineno Sliplineno
#define yyout Slipout
#define yyrestart Sliprestart
#define yytext Sliptext
#define yywrap Slipwrap
#define yyalloc Slipalloc
#define yyrealloc Sliprealloc
#define yyfree Slipfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 37
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE Sliprestart(Slipin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t Slipleng;

extern FILE *Slipin, *Slipout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up Sliptext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up Sliptext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via Sliprestart()), so that the user can continue scanning by
	 * just pointing Slipin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when Sliptext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t Slipleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow Slipwrap()'s to do buffer switches
 * instead of setting up a fresh Slipin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void Sliprestart (FILE *input_file  );
void Slip_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE Slip_create_buffer (FILE *file,int size  );
void Slip_delete_buffer (YY_BUFFER_STATE b  );
void Slip_flush_buffer (YY_BUFFER_STATE b  );
void Slippush_buffer_state (YY_BUFFER_STATE new_buffer  );
void Slippop_buffer_state (void );

static void Slipensure_buffer_stack (void );
static void Slip_load_buffer_state (void );
static void Slip_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER Slip_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE Slip_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE Slip_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE Slip_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *Slipalloc (yy_size_t  );
void *Sliprealloc (void *,yy_size_t  );
void Slipfree (void *  );

#define yy_new_buffer Slip_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        Slipensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            Slip_create_buffer(Slipin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        Slipensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            Slip_create_buffer(Slipin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define Slipwrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *Slipin = (FILE *) 0, *Slipout = (FILE *) 0;

typedef int yy_state_type;

extern int Sliplineno;

int Sliplineno = 1;

extern char *Sliptext;
#define yytext_ptr Sliptext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up Sliptext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	Slipleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 60
#define YY_END_OF_BUFFER 61
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[156] =
    {   0,
        0,    0,    0,    0,   45,   45,    0,    0,   61,   40,
       22,   23,   18,   10,   40,   19,    4,    5,   40,    1,
       40,   40,   40,   40,    3,    2,    8,    9,   40,   40,
       40,    6,    7,   43,   44,   41,   45,   46,   59,   49,
       60,   60,   60,   22,   39,    0,   39,    0,    0,    0,
        0,   20,   21,   24,    0,    0,    0,    0,    0,    0,
       27,    0,    0,    0,    0,    0,   17,   11,   12,   13,
       14,   15,   16,   43,    0,    0,   41,   42,   45,   59,
       47,   48,   58,   58,   58,   53,   54,   55,   56,   57,
       58,   34,    0,   33,    0,    0,   25,    0,    0,   26,

        0,    0,    0,   28,   29,    0,    0,    0,   50,   52,
       51,    0,    0,    0,    0,   35,   30,    0,    0,    0,
       30,    0,    0,    0,    0,    0,    0,    0,   50,   52,
       51,   30,   31,   32,    0,    0,   30,    0,   30,   31,
       32,    0,   38,   38,   50,   52,    0,   30,   37,   37,
        0,    0,   36,    0,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    4,    4,    8,    9,
       10,   11,   12,   13,   12,   14,   15,   16,   17,   18,
       18,   18,   18,   18,   18,   19,   19,   20,   21,   22,
        4,   23,    4,    4,   24,   25,   26,   25,   27,   28,
        7,    7,    7,    7,    7,   29,    7,    7,    7,   30,
        7,   31,   32,   33,   34,    7,    7,   35,    7,    7,
       36,   37,   38,    4,    7,    4,   39,   40,   26,   41,

       27,   42,   43,    7,   43,    7,    7,   29,    7,   44,
        7,   30,    7,   45,   32,   46,   34,    7,    7,   47,
        7,    7,   48,   49,   50,    4,    1,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,

       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51
    } ;

static yyconst flex_int32_t yy_meta[52] =
    {   0,
        1,    1,    2,    3,    4,    3,    3,    4,    1,    1,
        3,    3,    1,    5,    1,    6,    6,    6,    6,    7,
        1,    1,    1,    8,    8,    9,   10,    8,   11,   12,
        3,    3,    3,    5,    3,   12,    4,   13,    8,    8,
       14,    8,   12,    3,    3,   12,   12,    1,    7,    1,
       15
    } ;

static yyconst flex_int16_t yy_base[183] =
    {   0,
        0,    0,   49,   50,  228,  225,   51,   59,  221,  944,
      205,  944,  944,  944,   96,  944,  944,  944,   52,  944,
       56,   65,  146,  183,  944,  944,  944,  944,  217,   55,
       45,  944,  944,  167,  944,   66,    0,  944,    0,  944,
        0,    0,  252,  156,  944,   39,   68,   85,   96,  286,
      108,  944,  944,  944,  112,   48,    0,  124,   29,  135,
      944,    0,    0,  108,  147,  150,  944,  944,  944,  944,
      944,  944,  944,   71,  139,   54,  142,   46,    0,    0,
      944,  944,  944,  104,  187,  944,  944,  944,  944,  944,
        0,  944,  217,  944,  197,  230,  944,  234,  241,  944,

      153,  320,  370,  944,  944,  159,  159,  184,  227,  245,
        0,  256,  260,  264,  290,  944,  944,  421,    0,  161,
      405,  412,  419,  434,  441,  463,  262,  510,  308,  334,
      944,  944,  944,  944,  196,  102,  427,  541,    0,    0,
        0,  590,  944,   69,  944,  944,  121,  242,  944,  153,
      339,  477,  944,  483,  944,  640,  655,  670,  685,  699,
      710,  725,  740,  755,  770,  785,  792,  799,  814,  824,
      834,  841,  847,  861,  868,  874,  888,  890,  904,  911,
      916,  930
    } ;

static yyconst flex_int16_t yy_def[183] =
    {   0,
      155,    1,  156,  156,  157,  157,  158,  158,  155,  155,
      155,  155,  155,  155,  159,  155,  155,  155,  155,  155,
      155,  155,  155,  160,  155,  155,  155,  155,  159,   29,
      161,  155,  155,  162,  155,  163,  164,  155,  165,  155,
      166,  167,  168,  155,  155,   29,   29,  155,  155,  160,
      169,  155,  155,  155,  170,   23,  171,  155,  172,  173,
      155,   50,  174,  175,   29,   29,  155,  155,  155,  155,
      155,  155,  155,  162,  163,  163,  163,  163,  164,  165,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      176,  155,  155,  155,  170,  155,  155,  155,  177,  155,

      172,  155,  155,  155,  155,  175,   29,   29,  155,  155,
      178,  155,  169,  155,  170,  155,  155,  102,  179,  180,
      155,  155,  102,  118,  179,  180,   29,  159,  155,  155,
      155,  155,  155,  155,  180,  181,  181,  102,  137,  137,
      137,  159,  155,   29,  155,  155,  155,  155,  155,   29,
      155,  182,  155,  182,    0,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155
    } ;

static yyconst flex_int16_t yy_nxt[996] =
    {   0,
       10,   11,   12,   10,   13,   14,   15,   16,   17,   18,
       10,   19,   20,   21,   22,   23,   24,   24,   24,   25,
       26,   27,   28,   15,   15,   15,   15,   29,   15,   15,
       15,   15,   30,   15,   15,   10,   31,   10,   15,   15,
       15,   29,   15,   15,   15,   30,   15,   32,   19,   33,
       10,   35,   35,   40,  101,   41,   75,  101,   42,   36,
       36,   40,   46,   41,   75,   48,   42,   49,   50,   50,
       50,   51,   51,   51,   51,   52,   77,   46,   46,   53,
       78,   75,  155,   68,   69,   66,   70,   43,   71,   72,
       73,   46,   46,   46,  155,   43,   45,   45,   45,   66,

       51,   51,   51,   51,   45,   45,   46,   46,   45,   55,
       45,   49,   49,   49,   49,   45,   45,   45,   45,  109,
      109,  109,   58,   51,   51,   51,   51,   95,   95,   95,
       95,  147,  151,  106,   93,   98,  106,  147,   96,   99,
       99,   99,   99,   45,   47,   45,   54,   54,   54,   75,
      147,  103,   77,   78,   54,   54,   78,   44,   54,   55,
       54,   56,   56,   56,   49,   54,   54,   54,   54,  151,
       46,   57,   58,   46,   57,  107,   46,   75,  155,   59,
       60,  155,   46,  108,  155,   46,  135,  155,   46,  135,
      127,   46,   60,   54,   54,   54,   55,   46,   62,   62,

       62,   62,  110,  110,  110,  110,   44,   46,   63,   58,
      128,   63,   95,   95,   95,   95,   64,   45,   45,   45,
      155,  155,   46,   96,  155,   45,   45,   38,  112,   45,
       38,   45,  113,  113,  113,  113,   45,   45,   45,   45,
       65,  114,  129,  129,  129,  115,  115,  115,  115,   99,
       99,   99,   99,  151,  155,   65,   99,   99,   99,   99,
      130,  130,  130,  130,   45,   47,   45,   84,   85,   85,
       85,  113,  113,  113,  113,  113,  113,  113,  113,  115,
      115,  115,  115,  155,  155,   46,  155,  155,  142,  155,
      151,   86,  155,   87,  155,   88,   89,   90,   91,   55,

       46,   62,   62,   62,   62,  115,  115,  115,  115,  155,
      155,   63,   58,  155,   63,  155,  155,  155,  155,   64,
      117,  117,  117,  145,  145,  145,  155,  155,  117,  117,
      155,  155,  117,  155,  117,  102,  102,  102,  102,  117,
      117,  117,  117,  102,  102,  118,  102,  102,  119,  146,
      146,  146,  146,  120,  152,  152,  152,  152,  102,  102,
      102,  102,  155,  155,  155,  155,  155,  117,  117,  117,
      121,  121,  117,  122,  122,  122,  122,  122,  121,  121,
      122,  122,  121,  122,  121,  123,  123,  123,  123,  121,
      121,  121,  121,  123,  123,  124,  123,  123,  125,  122,

      122,  122,  122,  126,  122,  122,  122,  122,  123,  123,
      123,  123,  122,  122,  122,  122,  122,  121,  121,  121,
      122,  132,  132,  132,  136,  155,  155,  155,  155,  132,
      132,  136,  155,  132,  155,  132,  155,  155,  137,  155,
      132,  132,  132,  132,  155,  136,  155,  136,  155,  155,
      136,  136,  136,  139,  136,  155,  147,  136,  136,  138,
      140,  136,  147,  155,  136,  136,  155,  155,  132,  132,
      132,  155,  155,  155,  138,  147,  136,  155,  155,  136,
      136,  136,  141,  136,  155,  155,  136,  136,  135,  155,
      155,  135,  152,  152,  152,  152,  155,  155,  155,  155,

      155,  155,  155,  136,  155,  136,  155,  155,  136,  136,
      143,  143,  143,  155,  154,  155,  155,  155,  143,  143,
      155,  155,  143,  155,  143,  155,  155,  155,  155,  143,
      143,  143,  143,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  143,  144,  143,
      137,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      147,  155,  155,  155,  155,  155,  147,  155,  155,  155,
      155,  138,  155,  136,  155,  155,  136,  136,  155,  148,
      149,  149,  149,  155,  155,  155,  155,  155,  149,  149,

      155,  155,  149,  155,  149,  155,  155,  155,  155,  149,
      149,  149,  149,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  149,  150,  149,
       34,   34,   34,   34,   34,   34,   34,   34,   34,   34,
       34,   34,   34,   34,   34,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       39,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,   39,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   61,

       61,  155,  155,   61,   61,   61,  155,   61,   61,   61,
       67,  155,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   74,  155,   74,   74,   74,
       74,   74,   74,   74,   74,   74,   74,   74,   74,   74,
       76,  155,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   79,  155,   79,   79,   79,
       79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
       80,  155,   80,  155,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   81,   81,  155,  155,  155,
      155,   81,   82,   82,  155,  155,  155,  155,   82,   83,

      155,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   92,   92,  155,  155,  155,   92,
       92,  155,  155,   92,   94,   94,  155,  155,  155,   94,
       94,  155,  155,   94,   97,   97,  155,  155,  155,  155,
       97,  100,  100,  155,  155,  155,  155,  100,  155,  100,
      155,  100,  102,  155,  102,  102,  102,  155,  155,  155,
      102,  104,  104,  155,  155,  155,  155,  104,  105,  105,
      155,  155,  155,  155,  105,  155,  105,  155,  105,  111,
      155,  111,  111,  111,  155,  155,  155,  111,  116,  116,
      155,  155,  155,  116,  116,  131,  155,  131,  131,  131,

      155,  155,  155,  131,  133,  133,  155,  155,  155,  155,
      133,  134,  134,  155,  155,  155,  155,  134,  155,  134,
      155,  134,  136,  155,  155,  155,  155,  136,  155,  136,
      153,  153,  155,  155,  155,  153,  153,  155,  155,  155,
      155,  155,  153,    9,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155

    } ;

static yyconst flex_int16_t yy_chk[996] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    4,    7,   59,    7,   78,   59,    7,    3,
        4,    8,   46,    8,   76,   19,    8,   19,   19,   19,
       19,   21,   21,   21,   21,   22,   36,   46,   30,   22,
       36,   74,   56,   31,   31,   30,   31,    7,   31,   31,
       31,   47,  144,   30,   56,    8,   15,   15,   15,   30,

       48,   48,   48,   48,   15,   15,   47,  144,   15,   49,
       15,   49,   49,   49,   49,   15,   15,   15,   15,   84,
       84,   84,   49,   51,   51,   51,   51,   55,   55,   55,
       55,  136,  147,   64,   51,   58,   64,  136,   55,   58,
       58,   58,   58,   15,   15,   15,   23,   23,   23,   75,
      136,   60,   77,   75,   23,   23,   77,   44,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,  147,
       65,   23,   23,   66,   23,   65,  150,   34,  101,   23,
       23,  101,  107,   66,  106,   65,  120,  106,   66,  120,
      107,  150,   23,   23,   23,   23,   24,  107,   24,   24,

       24,   24,   85,   85,   85,   85,   11,  108,   24,   24,
      108,   24,   95,   95,   95,   95,   24,   29,   29,   29,
        9,  135,  108,   95,  135,   29,   29,    6,   93,   29,
        5,   29,   93,   93,   93,   93,   29,   29,   29,   29,
       29,   96,  109,  109,  109,   96,   96,   96,   96,   98,
       98,   98,   98,  148,    0,   29,   99,   99,   99,   99,
      110,  110,  110,  110,   29,   29,   29,   43,   43,   43,
       43,  112,  112,  112,  112,  113,  113,  113,  113,  114,
      114,  114,  114,    0,    0,  127,  113,    0,  127,    0,
      148,   43,    0,   43,    0,   43,   43,   43,   43,   50,

      127,   50,   50,   50,   50,  115,  115,  115,  115,    0,
        0,   50,   50,    0,   50,    0,  115,    0,    0,   50,
      102,  102,  102,  129,  129,  129,    0,    0,  102,  102,
        0,    0,  102,    0,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  130,
      130,  130,  130,  102,  151,  151,  151,  151,  102,  102,
      102,  102,    0,    0,    0,    0,    0,  102,  102,  102,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,

      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  118,  118,  118,  121,    0,    0,    0,    0,  118,
      118,  122,    0,  118,    0,  118,    0,    0,  123,    0,
      118,  118,  118,  118,    0,  121,    0,  121,    0,    0,
      121,  121,  122,  124,  122,    0,  137,  122,  122,  123,
      125,  123,  137,    0,  123,  123,    0,    0,  118,  118,
      118,    0,    0,    0,  124,  137,  124,    0,    0,  124,
      124,  125,  126,  125,    0,    0,  125,  125,  126,    0,
        0,  126,  152,  152,  152,  152,    0,    0,  154,  154,

      154,  154,    0,  126,    0,  126,    0,    0,  126,  126,
      128,  128,  128,    0,  152,    0,    0,    0,  128,  128,
      154,    0,  128,    0,  128,    0,    0,    0,    0,  128,
      128,  128,  128,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  128,  128,  128,
      138,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      138,    0,    0,    0,    0,    0,  138,    0,    0,    0,
        0,  138,    0,  138,    0,    0,  138,  138,    0,  138,
      142,  142,  142,    0,    0,    0,    0,    0,  142,  142,

        0,    0,  142,    0,  142,    0,    0,    0,    0,  142,
      142,  142,  142,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  142,  142,  142,
      156,  156,  156,  156,  156,  156,  156,  156,  156,  156,
      156,  156,  156,  156,  156,  157,  157,  157,  157,  157,
      157,  157,  157,  157,  157,  157,  157,  157,  157,  157,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  160,

      160,    0,    0,  160,  160,  160,    0,  160,  160,  160,
      161,    0,  161,  161,  161,  161,  161,  161,  161,  161,
      161,  161,  161,  161,  161,  162,    0,  162,  162,  162,
      162,  162,  162,  162,  162,  162,  162,  162,  162,  162,
      163,    0,  163,  163,  163,  163,  163,  163,  163,  163,
      163,  163,  163,  163,  163,  164,    0,  164,  164,  164,
      164,  164,  164,  164,  164,  164,  164,  164,  164,  164,
      165,    0,  165,    0,  165,  165,  165,  165,  165,  165,
      165,  165,  165,  165,  165,  166,  166,    0,    0,    0,
        0,  166,  167,  167,    0,    0,    0,    0,  167,  168,

        0,  168,  168,  168,  168,  168,  168,  168,  168,  168,
      168,  168,  168,  168,  169,  169,    0,    0,    0,  169,
      169,    0,    0,  169,  170,  170,    0,    0,    0,  170,
      170,    0,    0,  170,  171,  171,    0,    0,    0,    0,
      171,  172,  172,    0,    0,    0,    0,  172,    0,  172,
        0,  172,  173,    0,  173,  173,  173,    0,    0,    0,
      173,  174,  174,    0,    0,    0,    0,  174,  175,  175,
        0,    0,    0,    0,  175,    0,  175,    0,  175,  176,
        0,  176,  176,  176,    0,    0,    0,  176,  177,  177,
        0,    0,    0,  177,  177,  178,    0,  178,  178,  178,

        0,    0,    0,  178,  179,  179,    0,    0,    0,    0,
      179,  180,  180,    0,    0,    0,    0,  180,    0,  180,
        0,  180,  181,    0,    0,    0,    0,  181,    0,  181,
      182,  182,    0,    0,    0,  182,  182,    0,    0,    0,
        0,    0,  182,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155

    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int Slip_flex_debug;
int Slip_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *Sliptext;
/*
  * Maintenance:
  * Compile: flex --noline slip.lex
  * Fixup:   cp lex.Slip.c ../slip/lex.Slip.cpp;
 */
# include <stdio.h>
# include <cerrno>
# include <cstdlib>
# include <cstring>
# include <ctype.h>
# include <string>
# include <stdint.h>
# include "lex.Slip.h"
# include "Slip.Bison.hpp"

using namespace std;
using namespace slip;

#define YY_DECL int Sliplex( parser::semantic_type* yylval\
                           , parser::location_type* yylloc)
                           
#undef DEBUG
#ifdef DEBUG_IO
   #define DEBUG(flag, stmt) if (flag) stmt
#else
   #define DEBUG(flag, stmt)
#endif

# define ATOF myatof
double myatof(char * const);

#define TOKEN slip::parser::token
#define MAX_STR_CONST 1025
   
   using namespace std;
   
   bool  lexerDebugFlag = false;

   string getFileName();                           /* get current file name */

   int  col = 1;                                   /* start column of token */
   int  lineno = 1;                                /* line number of token  */
   
#define INITIAL 0
#define COMMENT 1
#define EOLCOMMENT 2
#define STRING_CHAR 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int Sliplex_destroy (void );

int Slipget_debug (void );

void Slipset_debug (int debug_flag  );

YY_EXTRA_TYPE Slipget_extra (void );

void Slipset_extra (YY_EXTRA_TYPE user_defined  );

FILE *Slipget_in (void );

void Slipset_in  (FILE * in_str  );

FILE *Slipget_out (void );

void Slipset_out  (FILE * out_str  );

yy_size_t Slipget_leng (void );

char *Slipget_text (void );

int Slipget_lineno (void );

void Slipset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int Slipwrap (void );
#else
extern int Slipwrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( Sliptext, Slipleng, 1, Slipout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( Slipin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( Slipin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, Slipin))==0 && ferror(Slipin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(Slipin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int Sliplex (void);

#define YY_DECL int Sliplex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after Sliptext and Slipleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
     bool stringFlag = false;                        /* false; quoted char    */
     string *string_buf = NULL;                      /* input string buffer   */

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! Slipin )
			Slipin = stdin;

		if ( ! Slipout )
			Slipout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			Slipensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				Slip_create_buffer(Slipin,YY_BUF_SIZE );
		}

		Slip_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of Sliptext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 156 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 944 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
case 8:
case 9:
case 10:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d %c                  %s\n", lineno, col, Sliptext[0], Sliptext);) 
                                   col++; 
                                   return Sliptext[0]; }
	YY_BREAK
case 11:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\a                %s\n", lineno, col, Sliptext);) col++; 
                                   yylval->CHAR = '\a';
                                   return TOKEN::CHAR;}
	YY_BREAK
case 12:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\b                %s\n", lineno, col, Sliptext);) col++;
                                   yylval->CHAR = '\b';
                                   return TOKEN::CHAR;}
	YY_BREAK
case 13:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\f                %s\n", lineno, col, Sliptext);) col++;
                                   yylval->CHAR = '\f';
                                   return TOKEN::CHAR;}
	YY_BREAK
case 14:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\n                %s\n", lineno, col, Sliptext);) col++;
                                   yylval->CHAR = '\n';
                                   return TOKEN::CHAR;}
	YY_BREAK
case 15:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\r                %s\n", lineno, col, Sliptext);) col++;
                                   yylval->CHAR = '\r';
                                   return TOKEN::CHAR;}
	YY_BREAK
case 16:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\t                %s\n", lineno, col, Sliptext);) col++;
                                   yylval->CHAR = '\t';
                                   return TOKEN::CHAR;}
	YY_BREAK
case 17:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\.                %s\n", lineno, col, Sliptext);) col++;
                                   yylval->CHAR = '.';
                                   return TOKEN::CHAR;}
	YY_BREAK
case 18:
case 19:
YY_RULE_SETUP
{ string whoWeAre = (Sliptext[0] == '"')? "STRING": "CHAR  ";
                                   DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d BEGIN %-s       %s\n", lineno, col, whoWeAre.c_str(), Sliptext);) 
                                   col++;
                                   string_buf = new string();
                                   stringFlag = (Sliptext[0] == '"')? true: false;
                                   BEGIN(STRING_CHAR); }
	YY_BREAK
case 20:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d /* BEGIN COMMENT   %s\n", lineno, col, Sliptext);) col++; 
                                   BEGIN(COMMENT); }
	YY_BREAK
case 21:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d EOL COMMENT        %s\n", lineno, col, Sliptext);) col++; 
                                   BEGIN(EOLCOMMENT); }
	YY_BREAK
case 22:
YY_RULE_SETUP
{ col += Slipleng; }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\n\n", lineno, col); lineno++; col=1;) }
	YY_BREAK
case 24:
/* rule 24 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d OCTAL              %s\n", lineno, col, Sliptext);) col += Slipleng; 
                                   long int value = strtol(Sliptext, NULL, 0);
                                   yylval->INTEGER = value;
                                   return TOKEN::INTEGER; }
	YY_BREAK
case 25:
/* rule 25 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d OCTAL[C|L]         %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   long int value = strtol(Sliptext, NULL, 0);
                                   yylval->INTEGER = value;
                                   TOKEN::yytokentype token    = TOKEN::INTEGER;
                                   if ((Sliptext[Slipleng-1] | 0x20) == 'c') {
                                       token      = TOKEN::CHAR;
                                       yylval->CHAR = yylval->INTEGER;
                                   }
                                   return token;
                                 }
	YY_BREAK
case 26:
/* rule 26 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d OCTAL[UC|UL]       %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   long unsigned int value = strtoul(Sliptext, NULL, 0);
                                   yylval->UINTEGER = value;
                                   TOKEN::yytokentype token     = TOKEN::UINTEGER;
                                   if ((Sliptext[Slipleng-1] | 0x20) == 'c') {
                                       token       = TOKEN::UCHAR;
                                       yylval->UCHAR = yylval->UINTEGER;
                                   }
                                   return token;
                                 }
	YY_BREAK
case 27:
/* rule 27 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d DECIMAL            %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->INTEGER = atoi(Sliptext);
                                   return TOKEN::INTEGER; }
	YY_BREAK
case 28:
/* rule 28 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d DECIMAL[C|L]       %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->INTEGER = atoi(Sliptext);
                                   TOKEN::yytokentype token    = TOKEN::INTEGER;
                                   if ((Sliptext[Slipleng-1] | 0x20) == 'c') {
                                       token      = TOKEN::CHAR;
                                       yylval->CHAR = yylval->INTEGER;
                                   }
                                   return token;
                                 }
	YY_BREAK
case 29:
/* rule 29 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d DECIMAL[UC|UL]     %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   long unsigned int value = strtoul(Sliptext, NULL, 0);
                                   yylval->UINTEGER = value;
                                   TOKEN::yytokentype token     = TOKEN::UINTEGER;
                                   if ((Sliptext[Slipleng-1] | 0x20) == 'c') {
                                       token       = TOKEN::UCHAR;
                                       yylval->UCHAR = yylval->UINTEGER;
                                   }
                                   return token;
                                 }
	YY_BREAK
case 30:
/* rule 30 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d HEXADECIMAL        %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   long int value = strtol(Sliptext, NULL, 0);
                                   yylval->UINTEGER = value;
                                   return TOKEN::INTEGER; }
	YY_BREAK
case 31:
/* rule 31 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d HEXADECIMAL[C|L]   %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   long int value = strtol(Sliptext, NULL, 0);
                                   yylval->UINTEGER = value;
                                   TOKEN::yytokentype token    = TOKEN::INTEGER;
                                   if ((Sliptext[Slipleng-1] | 0x20) == 'c') {
                                       token      = TOKEN::CHAR;
                                       yylval->CHAR = yylval->INTEGER;
                                   }
                                   return token;
                                 }
	YY_BREAK
case 32:
/* rule 32 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d HEXADECIMAL[UC|UL] %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   long unsigned int value = strtoul(Sliptext, NULL, 0);
                                   yylval->UINTEGER = value;
                                   TOKEN::yytokentype token     = TOKEN::UINTEGER;
                                   if ((Sliptext[Slipleng-1] | 0x20) == 'c') {
                                       token       = TOKEN::UCHAR;
                                       yylval->UCHAR = yylval->UINTEGER;
                                   }
                                   return token;
                                 }
	YY_BREAK
case 33:
/* rule 33 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d 1.E1               %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->FLOAT = atof(Sliptext);
                                   return TOKEN::FLOAT; }
	YY_BREAK
case 34:
/* rule 34 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d  .E2               %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->FLOAT = atof(Sliptext);
                                   return TOKEN::FLOAT; }
	YY_BREAK
case 35:
/* rule 35 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d 3E3                %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->FLOAT = atof(Sliptext);
                                   return TOKEN::FLOAT; }
	YY_BREAK
case 36:
/* rule 36 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d hexfloat           %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->FLOAT = ATOF(Sliptext);
                                   return TOKEN::FLOAT; }
	YY_BREAK
case 37:
/* rule 37 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp = yy_bp + 5;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d FALSE              %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->BOOL = false;
                                   return TOKEN::BOOL; }
	YY_BREAK
case 38:
/* rule 38 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp = yy_bp + 4;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d TRUE               %s\n", lineno, col, Sliptext);) col += Slipleng;
                                   yylval->BOOL = true;
                                   return TOKEN::BOOL; }
	YY_BREAK
case 39:
/* rule 39 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{ 
                                   col += Slipleng; 
                                   if (!strcmp("include", Sliptext)) {
                                      DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d include            %s\n", lineno, col, Sliptext);) 
                                      return TOKEN::INCLUDE;
                                   } else if (!strcmp("user", Sliptext)) {
                                      DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d user               %s\n", lineno, col, Sliptext);) 
                                      return TOKEN::USER;
                                   } else {
                                      DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d NAME               %s\n", lineno, col, Sliptext);) 
                                      yylval->STRING = new string(Sliptext);
                                      return TOKEN::NAME;
                                   }
                                 }
	YY_BREAK
case 40:
YY_RULE_SETUP
{ 
                                   /* collect all illegal characters into buffer  */
                                   /* This is the default junk collector. When    */
                                   /* an illegal construct is discovered this     */
                                   /* little jewel puts all illegal characters    */
                                   /* into a buffer, tokenizes it and then ships  */
                                   /* it to the parser.                           */

                                   /**********************************************************************/
                                   /* Character Translation Table: '1' character is not legal.           */
                                   /**********************************************************************/
                                   
                                     static const char xTable[256] =             /* class translation table*/
                                     {
                                   /*
                                   nul  soh  stx  etx  eot  enq  ack  bel  bs   hs   lf   vt   ff   cr   so   si*/
                                     1,   1,   1,   1,   1,   1,   1,   0,   1,   1,  0,   0,   0,   0,   1,   1,
                                   
                                   /*
                                   dle  dc1  dc2  dc3  dc4  nak  syn  etb  can  em   sub  esc  fs   gs   rs   us*/
                                     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                                   
                                   /*
                                   sp    !    "    #    $    %    &    '    (    )    *    +    -    ,    .    /*/
                                     0,   1,   1,   1,   1,   1,   1,   1,   0,   0,   1,   1,   1,   0,   1,   0,
                                   
                                   /*
                                    0    1    2    3    4    5    6    7    8    9    :    ;    <    =    >    ?*/
                                     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   1,   0,   1,
                                   
                                   /*
                                    @    A    B    C    D    E    F    G    H    I    J    K    L    M    N    O*/
                                     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                                   
                                   /*
                                    P    Q    R    S    T    U    V    W    X    Y    Z    [    \    ]    ^    _*/
                                     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                                   
                                   /*
                                    `    a    b    c    d    e    f    g    h    i    j    k    l    m    n    o*/
                                     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
                                   
                                   /*
                                    p    q    r    s    t    u    v    w    x    y    z    {    |    }    ~  del*/
                                     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   1,   0,   1,   1,
                                   
                                   /* the remaining 128 characters are not part of the legal ASCII character set*/
                                     };                                   
                                   char  buffer[256];
                                   char* ptr = buffer;
                                   *ptr = Sliptext[0];
                                   do {
                                      if (ptr < &buffer[255])
                                         *(++ptr) = yyinput();
                                      else break;
                                   } while (xTable[(int)*ptr]);
                                   unput(*ptr);
                                   *ptr = 0;
                                   printf("Lex: %s:%d.%d illegal character(s) in file \"%s\"\n"
                                         , getFileName().c_str(), lineno, col, buffer);
                                   col += (ptr - buffer);
                                 }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
{ return TOKEN::END; }
	YY_BREAK

case 41:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d COMMENT ***        `%s`\n", lineno, col, Sliptext);) col += Slipleng; }
	YY_BREAK
case 42:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d END COMMENT        `%s`\n", lineno, col, Sliptext);) col += Slipleng; 
                                   BEGIN(INITIAL); }
	YY_BREAK
case 43:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d COMMENT [^*\\n]    `%s`\n", lineno, col, Sliptext);) col += Slipleng; }
	YY_BREAK
case YY_STATE_EOF(COMMENT):
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d COMMENT EOL\n", lineno, col);) lineno++; 
                                   BEGIN(INITIAL);
                                   return TOKEN::END; }
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d COMMENT \\n\n", lineno, col);) lineno++; col=1; }
	YY_BREAK
/* <COMMENT> */

case 45:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d EOL COMMENT        `%s`\n", lineno, col, Sliptext);) col += Slipleng; }
	YY_BREAK
case YY_STATE_EOF(EOLCOMMENT):
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d END COMMENT \\n\n", lineno, col);) lineno++; col=1; 
                                   BEGIN(INITIAL);
                                   return TOKEN::END; }
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d END COMMENT \\n\n", lineno, col);) lineno++; col = 1; 
                                   BEGIN(INITIAL); }
	YY_BREAK
/* <EOLCOMMENT> */

case 47:
/* rule 47 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{  if (stringFlag) {
                                       DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d END STRING         \"%s\"\n", lineno, col, string_buf->c_str());) 
                                       col += Slipleng;
                                       BEGIN(INITIAL); 
                                       yylval->STRING = string_buf;
                                       return TOKEN::STRING;
                                    } else {
                                       DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d CHARACTER \"        \'%s\'\n", lineno, col, Sliptext);) 
                                       col += Slipleng;
                                       string_buf->append(Sliptext);
                                    }
                                 }
	YY_BREAK
case 48:
/* rule 48 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up Sliptext */
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up Sliptext again */
YY_RULE_SETUP
{  if (!stringFlag) {
                                       DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d END CHARACTER      \'%s\'\n", lineno, col, string_buf->c_str());) 
                                       col += Slipleng;
                                       BEGIN(INITIAL); 
                                       if (string_buf->size() > 1) {
                                          printf("Lex: %s:%d.%d converting to string \"%s\"\n"
                                                        , getFileName().c_str(), lineno, col, string_buf->c_str());
                                          yylval->STRING = string_buf;
                                          return TOKEN::STRING;
                                       } else {
                                          yylval->CHAR = (string_buf->c_str())[0];
                                          delete string_buf;
                                          return TOKEN::CHAR;
                                       }
                                    } else {
                                       DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING   '            \"%s\"\n", lineno, col, Sliptext);) 
                                       col += Slipleng;
                                       string_buf->append(Sliptext);
                                    }
                                 }
	YY_BREAK
case YY_STATE_EOF(STRING_CHAR):
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d END STRING FAIL    \"%s\"\n", lineno, col, string_buf->c_str());) 
                                   col += Slipleng;
                                   printf("Lex: %s:%d.%d EOF file before terminal quote \"%s\": ignored\n"
                                                 , getFileName().c_str(), lineno, col, string_buf->c_str());
                                   BEGIN(INITIAL); 
                                   yylval->STRING = string_buf;
                                   return TOKEN::STRING;
                                 }
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
{ col = 1; lineno++; }
	YY_BREAK
case 50:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\0[0-7]{1,3}       \"%s\"\n", lineno, col, Sliptext);) 
                                   col += Slipleng;
                                   char result[2] = {0, 0};
                                   (void) sscanf( (Sliptext + 1), "%o", (unsigned int*)&result[0] );
                                   string_buf->append(result);
                                }
	YY_BREAK
case 51:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d \\x:xdigit:{1,2}   \"%s\"\n", lineno, col, Sliptext);) 
                                   col += Slipleng;
                                   char result[2] = {0, 0};
                                   (void) sscanf( (Sliptext + 2), "%x", (unsigned int*)&result[0] );
                                   string_buf->append(result);
                                 }
	YY_BREAK
case 52:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d [1-9]:digit:{1,2}   \"%s\"\n", lineno, col, Sliptext);) 
                                   col += Slipleng;
                                   union {
                                     int32_t result;
                                     char    array[5];
                                   } r;
                                   r.array[4] = 0;
                                   (void) sscanf( (Sliptext + 1), "%d", &r.result );
                                   if (r.result > 0xFF) {
                                     printf("Lex: %s:%d.%d illegal decimal number in file \"%s\": ignored\n"
                                                   , getFileName().c_str(), lineno, col, Sliptext);
                                   } else string_buf->append(&r.array[0]);
                                 }
	YY_BREAK
case 53:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING \\b            \"%s\"\n", lineno, col, Sliptext);) col += Slipleng;
                                  string_buf->append("\b");
                                }
	YY_BREAK
case 54:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING \\f            \"%s\"\n", lineno, col, Sliptext);) col += Slipleng;
                                  string_buf->append("\f");
                                }
	YY_BREAK
case 55:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING \\n            \"%s\"\n", lineno, col, Sliptext);) col += Slipleng;
                                  string_buf->append("\n");
                                }
	YY_BREAK
case 56:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING \\r            \"%s\"\n", lineno, col, Sliptext);) col += Slipleng;
                                  string_buf->append("\r");
                                }
	YY_BREAK
case 57:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING \\t            \"%s\"\n", lineno, col, Sliptext);) col += Slipleng;
                                  string_buf->append("\t");
                                }
	YY_BREAK
case 58:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING \\n         \"%s\"\n", lineno, col, Sliptext);) col += Slipleng;
                                  string_buf->append(Sliptext);
                                }
	YY_BREAK
case 59:
YY_RULE_SETUP
{ DEBUG(lexerDebugFlag, printf("Lex: %3d:%4d STRING [^\\\\n\"]+    \"%s\"\n", lineno, col, Sliptext);) col += Slipleng;
                                  string_buf->append(Sliptext);
                                }
	YY_BREAK
/* <STRING_CHAR> */
case 60:
YY_RULE_SETUP
ECHO;
	YY_BREAK

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed Slipin at a new source and called
			 * Sliplex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = Slipin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( Slipwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * Sliptext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of Sliplex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					Sliprealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			Sliprestart(Slipin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) Sliprealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 156 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 156 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 155);

		return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up Sliptext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register yy_size_t number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					Sliprestart(Slipin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( Slipwrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve Sliptext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void Sliprestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        Slipensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            Slip_create_buffer(Slipin,YY_BUF_SIZE );
	}

	Slip_init_buffer(YY_CURRENT_BUFFER,input_file );
	Slip_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void Slip_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		Slippop_buffer_state();
	 *		Slippush_buffer_state(new_buffer);
     */
	Slipensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	Slip_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (Slipwrap()) processing, but the only time this flag
	 * is looked at is after Slipwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void Slip_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	Slipin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE Slip_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) Slipalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in Slip_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) Slipalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in Slip_create_buffer()" );

	b->yy_is_our_buffer = 1;

	Slip_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with Slip_create_buffer()
 * 
 */
    void Slip_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		Slipfree((void *) b->yy_ch_buf  );

	Slipfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a Sliprestart() or at EOF.
 */
    static void Slip_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	Slip_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then Slip_init_buffer was _probably_
     * called from Sliprestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void Slip_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		Slip_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void Slippush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	Slipensure_buffer_stack();

	/* This block is copied from Slip_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from Slip_switch_to_buffer. */
	Slip_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void Slippop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	Slip_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		Slip_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void Slipensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)Slipalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in Slipensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)Sliprealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in Slipensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE Slip_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) Slipalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in Slip_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	Slip_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to Sliplex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       Slip_scan_bytes() instead.
 */
YY_BUFFER_STATE Slip_scan_string (yyconst char * yystr )
{
    
	return Slip_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to Sliplex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE Slip_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) Slipalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in Slip_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = Slip_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in Slip_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up Sliptext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		Sliptext[Slipleng] = (yy_hold_char); \
		(yy_c_buf_p) = Sliptext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		Slipleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int Slipget_lineno  (void)
{
        
    return Sliplineno;
}

/** Get the input stream.
 * 
 */
FILE *Slipget_in  (void)
{
        return Slipin;
}

/** Get the output stream.
 * 
 */
FILE *Slipget_out  (void)
{
        return Slipout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t Slipget_leng  (void)
{
        return Slipleng;
}

/** Get the current token.
 * 
 */

char *Slipget_text  (void)
{
        return Sliptext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void Slipset_lineno (int  line_number )
{
    
    Sliplineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see Slip_switch_to_buffer
 */
void Slipset_in (FILE *  in_str )
{
        Slipin = in_str ;
}

void Slipset_out (FILE *  out_str )
{
        Slipout = out_str ;
}

int Slipget_debug  (void)
{
        return Slip_flex_debug;
}

void Slipset_debug (int  bdebug )
{
        Slip_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from Sliplex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    Slipin = stdin;
    Slipout = stdout;
#else
    Slipin = (FILE *) 0;
    Slipout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * Sliplex_init()
     */
    return 0;
}

/* Sliplex_destroy is for both reentrant and non-reentrant scanners. */
int Sliplex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		Slip_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		Slippop_buffer_state();
	}

	/* Destroy the stack itself. */
	Slipfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * Sliplex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *Slipalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *Sliprealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void Slipfree (void * ptr )
{
	free( (char *) ptr );	/* see Sliprealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

# include <string>
using namespace std;
/**
 * @file    Slip.lex
 * @author  A. Schwarz
 * @date November 16, 2013
 *
 * @brief Lexer regular expressions and integrated classes.
 *
 */

 /**
 * @brief Instantiation of state push/pop functionality
 */
class LexStateVariables;
LexStateVariables * variables = NULL;

/**
 * @class LexStateVariables
 * @brief Save, manage, and restore lexer state in include file processing.
 *
 *<p>When an include file is seen, the lexer state is saved. When an include
 *   file is exited, the lexer state is restored. The lexer state are those
 *   state variables not managed by the lexer, the current line nunber and
 *   column number.</p>
 * <p>On first entry to the lexer the line number and column number are stacked.
 *    On each instance of an include, the line number and column number are
 *    stacked, and on an include file EOF, the line numbers and column numbers
 *    of the previous context are restored. When processing of the inital
 *    lexer input file is terminated (with and EOF) then the file state is
 *    popped and the lexer exits.</p>
 */
class LexStateVariables {
  /**
   * @brief Structure maintains the lexer state.
   */
   struct Variables {
      int lineno;                                //!< lexor line number
      int col;                                   //!< lexer column number
      FILE * file;                               //!< fopen parameter
      string fileName;                           //!< filename
   }; // struct Variables
   static const int MAX_ARRAY_SIZE = 64;         //!< Initial allocation size
   Variables * stack;                            //!< Pointer to state stack
   int currentAllocation;                        //!< Current size of state stack
   int ndx;                                      //!< Next available state stack location
   public:
   /**
    * @brief Constructor for state stacking class.
    */
   LexStateVariables() : ndx(0)
                       , stack(new Variables[MAX_ARRAY_SIZE]) //!< Allocate initial stack size
                       , currentAllocation(MAX_ARRAY_SIZE)    //!< Initial allocation size
   { }
   
   /*
    * @brief Destructor for state stacking class.
    *
    * <p>The state stack is deleted.</p>
    */
   ~LexStateVariables() { delete stack; }
   
   /**
    * @brief Return the current state stack depth.
    * 
    * @return current depth of stack
    */
   int getDepth() { return ndx; }
   
   /**
    * @brief Return the filename of the currently open context.
    * @return (string) fileName of open context
    */
   string getFileName() { return stack[ndx-1].fileName; }
   
   /**
    * @brief Return the state of the stack;
    * <p>Each time an include file is seen, the current state is
    *    saved onto a stack. When the include file is existed, the
    *    current stack top is popped.</p>
    * <p>Prior to the first time that the lexer is entered, the
    *    current state is saved. This becomes the stack top.
    *    When all include files have been exited, the stack
    *    top is the stack state before first execution of 
    *    the lexer. When this state is popped, the lexer has
    *    seen the last End-Of-File, the End-Of-File of the
    *    initial file being processed. The lexer can not be
    *    entered again.</p>
    * <p>When there are no more entries on the state stack, we
         are done.</p>
    * @return <b>true</b> there are no more entries on the stack
    */
   bool isEmpty() {
      return (ndx <= 0);
   }; // bool isEmpty()
   
   /**
    * @brief Return <b>true</b> if the current state is the initial state.
    * <p>Each time an include file is seen, the current state is
    *    saved onto a stack. When the include file is existed, the
    *    current stack top is popped.</p>
    * <p>Prior to the first time that the lexer is entered, the
    *    current state is saved. This becomes the stack top.
    *    When all include files have been exited, the stack
    *    top is the stack state before first execution of 
    *    the lexer./p>
    * <p>When the current stack entry is the only entry, we are
    *    at the entry state to the lexer.</p>
    * @return <b>true</b> 
    */
   bool isTop() {
      return (ndx == 1);
   }; // bool isTop()
   
   /**
    * @brief Pop the last entry in the state stack.
    *
    * <p>The state, the line number and column number, is returned.
    *    If the stack is empty, the line number and column number
    *    are set to zero but no diagnostic message is output. This
    *    function is meant to perform in a well-behaved environment.</p>
    * @param[out] lineno (int) line number in the current file being scanned
    * @param[out] col (int) column number in the current file being scanned
    */
   void pop(int* lineno, int* col) {
      if (ndx >= 0) {
         toString(ndx-1, "pop");
         *lineno = stack[--ndx].lineno;
         *col    = stack[ndx].col;
      } else {
         *lineno = *col = 0;
      }
      return;
   }; // void push(int lineno, int col)
   
   /**
    * @brief Push a state stack entry.
    * <p>The lexer line number and column number are stacked. If the current
    *    stack is too small to hold another entry then a new stack is allocated
    *    with twice the size of the previous stack, all entries are copied and
    *    the old stack is deleted.</p>
    * @param[in] lineno (int) line number in the current file being scanned
    * @param[in] col (int) column number in the current file being scanned
    * @param[in] file (FILE*) open file object
    * @param[in] fileName (string) ASCII name of file
    */
   void push(int lineno, int col, string fileName, FILE * file) {
      if (ndx >= currentAllocation) {
         Variables * localStack = new Variables[2*currentAllocation];
         int localNdx = 0;
         while(localNdx < currentAllocation) 
            localStack[localNdx] = stack[localNdx++];
         currentAllocation *= 2;
         delete stack;
         stack = localStack;
      }
      stack[ndx].lineno   = lineno;
      stack[ndx].col      = col;
      stack[ndx].file     = file;
      stack[ndx].fileName = fileName;
      ndx++;
      toString(ndx-1, "push");
   }; // void push(int lineno, int col)

   /**
    * @brief Recover the previous lexical state.
    * <p>When an EOF is seen at the end of the lexer input file or
    *    the end of an 'include' file, the previous context is
    *    restored and the currently open file is closed. 
    *    Restoration restores the saved lexer state and
    *    the saved line number and column number.</p>
    *
    * @param[out] lineno (int) line number of previous context
    * @param[out] col (int) column number of previous context
    */
   void restoreLexState(int* lineno, int* col) {
      fclose(stack[ndx-1].file);
      Slippop_buffer_state();
      pop(lineno, col);
      return;
   }; // void restoreLexState()
       
   /*
    * @brief For each include file, stack the current state and open the file.
    *
    * <p>The input file is opened and the lexer state and column number and
    *    line number are stacked.</p>
    *
    * @param[in] fileName (string) include file name
    * @return <b>true</b> open of input file successful
    */
   bool saveLexState(string fileName) {
      bool retval = true;
      errno = 0;
      FILE * file = fopen(fileName.c_str(), "r");
      if (!file) {
         printf("Lexer:saveLexState Open File Error %s\n", strerror(errno));
         errno = 0;
         retval = false;
      } else {
         YY_BUFFER_STATE state = Slip_create_buffer ( file, YY_BUF_SIZE );
         Slippush_buffer_state(state);
         push(lineno, col, fileName, file);
         lineno = col = 1;
      }
      return retval;
   }; // bool saveLexState(string fileName)
   
   /**
    * @brief pretty print an entry from the stack.
    *
    * @param[in] ndx (int) stack entry index
    * @param[in] text (string&) title of output
    */
   void toString(const int ndx, const string& text) {
       DEBUG(lexerDebugFlag, printf("Lex: %4s stack[%d], %s:<%3d %3d>\n"
             , text.c_str(), ndx
             , stack[ndx].fileName.c_str()
             , stack[ndx].lineno
             , stack[ndx].col);)
   }; // void toString(const int ndx, const string& text)
}; // class LexStateVariables

/**
 * @brief Cleanup scanner by deleting allocated storage.
 */
void deleteLexState() {
   if (variables) delete variables;
   while(YY_CURRENT_BUFFER) Slippop_buffer_state ( );
}; // void deleteLexState()

/**
 * @brief Check lexer state for empty;
 * <p>Each time that an include file is processed, the lexer
      state gets stacked. Each time that an End-Of-File for
      the current processing input is reached, the lexer
      pops the current lexer state and processes the previous
      state. When the topmost state is popped, we are done.</p>
 * <p>This function returns <b>true</b> when the topmost lexer
      state has been popped.</p>
 * @return <b>true</b> if lexer topmost lexer state removed
 */
bool isEmpty() {
   return (variables->isEmpty());
}; // bool isEmpty

/**
 * @brief <b>true</b> if this is the initial file being processing.
 * <p>As each include file is processed, the current state is</p>
 *    pushed. As each include file is exited, the current state
 *    is restored to the previous state. If the current state is
 *    the initial state, we are at the top.
 * @return <b>true</b> the initial lexer file is being processed
 */
bool isTop() {
   return variables->isTop();
}; // bool isTop()

/**
 * @brief Get the file name of the current input file.
 * @return (string) file name
 */
string getFileName() {
   return variables->getFileName();
}; // string getFileName()

/**
 * @brief Open a file;
 * @param filename (string) file name and path.
 * @return File descriptor. If <b>null</b> then open failed.
 */
FILE* openFile(string filename) {
   FILE * file = fopen(filename.c_str(), "r");
   if (!file) {
      printf("Lexer:saveLexState Open File Error %s\n", strerror(errno));
   }
   return file;
}; // FILE* openFile(string filename)

/**
 * @brief Restore the previous lexer state.
 * <p>External interface which allows the previous lexer state to be 
 *    restored. Restoration allows the previous context to be recovered
 *    as if an intervening 'include' had not occurred.</p>
 * @note
 * <p>The lineno and col have file scope. They are not part of the 
 *    local scope and their values must be made available to the
 *    lexer. The lexer places the values in file scope and this
 *    little jewel uses it. It is a violation of basic development
 *    principles, but there you have it.</p>
 * @return <b>true</b> restore previous state
 */
bool restoreLexState() {
   bool flag = YY_CURRENT_BUFFER;
   if (!flag) delete variables;
   else variables->restoreLexState(&lineno, &col);
   return flag;
}; // bool restoreLexState()

/**
 * @brief For each include file, stack the current state.
 *
 * <p>This function accesses methods within the scope of the scanner
 *    file. This access to file scoped variables allows which does
 *    not require any file scoped variables allows usage outside of
 *    the scanner file, most particular in the parser. This function
 *    is the glue which allows the parser to perform lexer-centric
 *    operations.</p>
 *
 * @param[in] filename (string) include file name
 */
bool saveLexState(const string filename) {
   FILE* file = openFile(filename);
   if (!file) {
      return false;
   } else {
      if (variables == 0)
         variables = new LexStateVariables();
   }
   return variables->saveLexState(filename);
}; // bool saveLexState(string filename)

/**
 * @brief Turn debugging on.
*/
void setLexerDebugON() {
   lexerDebugFlag = true;
}; // void setLexerDebugON()

/**
 * @brief Turn debugging off.
*/
void setLexerDebugOFF() {
   lexerDebugFlag = false;
}; // void setLexerDebugOFF()

/**
 * @brief Converts a <i>hexfloat</i> into a double.
 * <p>The conforms to the IEEE 754 layout of double precision 64-bit) floating
 *    point numbers. A hardware or software implementation different from this
 *    standard will cause the algorithm to fail.</p>
 * <p>The algorithm assumes that a 64-bit memory representation is available
 *    in the hardware or through the compiler, and that the 64-bits are
 *    contiguous. Any operation made on the 64-bit memory item assumes that
 *    all 64-bits take part therefore a bit shift will shit within a 64-bit
 *    contiguous memory object.</p>
 * <p>It is assumed tht the input ASCII representation is legal. that is that
 *    it conforms exactly to a valid <i>hexfloat</i> representation. With this
 *    in mind:</p>
 * <ul>
 *    <li>Ignore leading non-graphic ASCII characters (except a <b>NUL</b>.</li>
 *    <li>Check for a signed <i>hexfloat</i>.</li>
 *    <ul>
 *       <li>If the leading character is a '+', ignore and increment over it.</li>
 *       <li>If the leading character is a '-', shift a '<b>1</b>' into the
 *           most signmificat bit of the 64-bit number and increment over the
 *           character.</li>
 *    </ul>
 *    <li>Set the mantissa to zero. For all characters in the mantissa:</li>
 *    <ul>
 *       <li>Convert the character into an integer.</li>
 *       <li>Shift the previous mantissa value by 4-bits.</li>
 *       <li>'or' the current value into the mantissa.</li>
 *       <li>Remember how many bits have been shifted.</li>
 *    </ul>
 *    <li>If the number of bits shifted is less than the allowable maximum,
 *        then shift the mantissa. If the number exceed the maximum, ignore,
 *        the returned value will not be legal.</li>
 *    <li>Process the exponent:</li>
 *    <ul>
 *       <li>Skip of the exponent indicator, '<b>p</b>'.</li>
 *       <li>Remember the exponsent sign (+, -).</li>
 *       <li>Construct the exponen valuet. The exponent is a decimal number,
 *           -1023 &lt; x &lt; 1023. </li>
 *       <li>Multiply by the sign, add the bias, and shift.</li>
 *       <li>'or' the exponent in to the double precision integer cognate.</li>
 *    </ul>
 * </ul>
 * @param str (char *) <i>hexfloat</i> string "0x1.#p#"
 * @return floating point value
 */
double myatof(char * str) {

      /**********************************************************************/
      /* Character Translation Table: '255' character is not legal.         */
      /**********************************************************************/

        static const uint8_t xTable[256] =             /* class translation table*/
        {
      /*
      nul  soh  stx  etx  eot  enq  ack  bel  bs   hs   lf   vt   ff   cr   so   si*/
      255, 255, 255, 255, 255, 255, 255, 255, 255, 255,255, 255, 255, 255, 255, 255,

      /*
      dle  dc1  dc2  dc3  dc4  nak  syn  etb  can  em   sub  esc  fs   gs   rs   us*/
      255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,

      /*
      sp    !    "    #    $    %    &    '    (    )    *    +    -    ,    .    /*/
      255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,

      /*
       0    1    2    3    4    5    6    7    8    9    :    ;    <    =    >    ?*/
        0,   1,   2,   3,   4,   5,   6,   7,   8,   9, 255, 255, 255, 255, 255, 255,

      /*
       @    A    B    C    D    E    F    G    H    I    J    K    L    M    N    O*/
      255,  10,  11,  12,  13,  14,  15, 255, 255, 255, 255, 255, 255, 255, 255, 255,

      /*
       P    Q    R    S    T    U    V    W    X    Y    Z    [    \    ]    ^    _*/
      255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,

      /*
       `    a    b    c    d    e    f    g    h    i    j    k    l    m    n    o*/
      255,  10,  11,  12,  13,  14,  15, 255, 255, 255, 255, 255, 255, 255, 255, 255,

      /*
       p    q    r    s    t    u    v    w    x    y    z    {    |    }    ~  del*/
      255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,

      /* the remaining 128 characters are not part of the legal ASCII character set*/
        };
   static const int MANTISSA_SHIFT =    52;
   static const int EXP_MASK       = 0x7ff;
   static const int EXP_BIAS       = 0x3ff;
   union {
      double     dbl;
      uint64_t dblDef;
   } result;
   uint64_t mantissa = 0;
   int      shift    = 0;
   int      digit    = 0;
   char*    p        = str;
   result.dbl = 0.0;
   while((*p > 0) && (*p <= (uint8_t)' ')) p++;
   if (*p != '0') {
      if (*p == '-')
         result.dblDef = (uint64_t)1 << 63;
      p++;
   }
   p += 4;

   while((digit = xTable[(uint8_t)*p]) != 255) {
      mantissa = (mantissa << 4) | digit;
      shift += 4;
      p++;
   }
   if (shift < MANTISSA_SHIFT) mantissa = mantissa << (MANTISSA_SHIFT - shift);
   result.dblDef |= mantissa;
   if (*p == 'p' || *p == 'P') {
      uint64_t exp = 0;
      p++;
      int sign = 1;
      if (*p == '+') p++;
      else if (*p == '-') {
         sign = -1;
         p++;
      }
      while((digit = xTable[(uint8_t)*p]) != 255) {
         exp = exp*10 + digit;
         p++;
      }
      exp   = sign*exp + EXP_BIAS;
      exp  &= EXP_MASK;
      exp <<= MANTISSA_SHIFT;
      result.dblDef |= exp;
   }
   return result.dbl;
}; // myatof

