
;;; d-dos-fonts.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-dos-fonts.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: MSDOS fontification
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(set-face-background 'default "white")

;;
;; font-lock-comment-face
;;
(make-face 'font-lock-comment-face)
(set-face-foreground 'font-lock-comment-face "green")

;;;
;;; d-face-super-comment
;;;
(make-face 'd-face-super-comment)
(set-face-foreground 'd-face-super-comment "lightred")

(make-face 'font-lock-string-face)
(set-face-foreground 'font-lock-string-face "white")
(set-face-background 'font-lock-string-face "lightblue")

(make-face 'font-lock-keyword-face)
(set-face-foreground 'font-lock-keyword-face "grey")
(set-face-background 'font-lock-keyword-face "white")

(make-face 'font-lock-constant-face)
(set-face-foreground 'font-lock-constant-face "white")
(set-face-background 'font-lock-constant-face "lightred")

(defun test-fontification  ()
  adfsdf)

(make-face 'font-lock-function-name-face)
(set-face-background 'font-lock-function-name-face "yellow")

(progn
  (make-face 'd-face-special-reference)
  (set-face-foreground 'd-face-special-reference "white")
  (set-face-background 'd-face-special-reference "lightgrey")
  )

(make-face 'fg:darkgray)
(make-face 'fg:lightblue)
(set-face-foreground 'fg:lightblue "lightblue")
(set-face-background 'fg:lightblue "white")

(copy-face 'fg:lightblue 'd-face-dired-directory)

(progn
  (make-face 'd-face-dired-deleteme)
  (set-face-background 'd-face-dired-deleteme "lightred")
  (set-face-foreground 'd-face-dired-deleteme "white")
  )

(progn
  (make-face 'd-face-dired-marked)
  (set-face-background 'd-face-dired-marked   "lightblue")
  (set-face-foreground 'd-face-dired-marked   "white")
  )

(progn
  (make-face 'font-lock-warning-face)
  (set-face-foreground 'font-lock-warning-face "white")
  (set-face-background 'font-lock-warning-face "lightred")
  )

(progn
  (make-face 'font-lock-variable-name-face)
  (set-face-foreground 'font-lock-variable-name-face "lightblue")
  (set-face-background 'font-lock-variable-name-face "white")
  )

(progn
  (make-face 'font-lock-type-face)
  (set-face-foreground 'font-lock-type-face "cyan")
  (set-face-background 'font-lock-type-face "white")
  )

(progn
  (make-face 'font-lock-builtin-face)
  (set-face-foreground 'font-lock-builtin-face "lightred")
  (set-face-background 'font-lock-builtin-face "white")
  )

(progn
  (make-face 'd-face-m4)
  (set-face-background 'd-face-m4 "lightred")
  (set-face-foreground 'd-face-m4 "white")
  )

(progn
  (make-face 'd-face-m5)
  (set-face-background 'd-face-m5 "green")
  (set-face-foreground 'd-face-m5 "white")
  )

(progn
  (make-face 'd-face-m6)
  (set-face-background 'd-face-m6 "lightblue")
  (set-face-foreground 'd-face-m6 "white")
  )

(progn
  (make-face 'fg:lightgreen)
  (set-face-foreground 'fg:lightgreen "green")
  (set-face-background 'fg:lightgreen "white")
  )

(make-face 'fg:lightmagenta)
(make-face 'fg:cyan)

(progn
  ;;
  ;; It is an error to use this face
  ;;
  (make-face 'fg:yellow)
  (set-face-background 'fg:yellow "lightmagenta")
  (set-face-foreground 'fg:yellow "lightcyan")
  )

(progn
  (make-face 'bg:yellow)
  (set-face-background 'bg:yellow "yellow")
  (set-face-foreground 'bg:yellow "black")
  )

(make-face 'fg:lightcyan)

(progn
  (make-face 'bg:lightmagenta)
  (set-face-background 'bg:lightmagenta "lightmagenta")
  (set-face-foreground 'bg:lightmagenta "white")
  )

(progn
  (make-face 'fg:lightmagenta)
  (set-face-foreground 'fg:lightmagenta "lightmagenta")
  (set-face-background 'fg:lightmagenta "white")
  )

(progn
  (make-face 'fg:lightred)
  (set-face-foreground 'fg:lightred "lightred")
  (set-face-background 'fg:lightred "white")
  )

(progn
  (make-face 'bg:lightred)
  (set-face-background 'bg:lightred "lightred")
  (set-face-foreground 'bg:lightred "white")
  )

(progn
  (make-face 'fg:orange)
  (set-face-foreground 'fg:orange "lightred")
  (set-face-background 'fg:orange "white")
  )

(progn
  (make-face 'fg:white)
  (set-face-background 'fg:white "white")
  )

(make-face 'bg:green)
(make-face 'bg:red)

(progn
  (make-face  'd-face-cc-allegro)
  (set-face-background 'd-face-cc-allegro "white")
  (set-face-foreground 'd-face-cc-allegro "brown")
  )

(progn
  (make-face  'd-face-cc-private)
  (set-face-background 'd-face-cc-private "lightgrey")
  (set-face-foreground 'd-face-cc-private "black")
  )

(progn
  (make-face  'd-face-cc-debugging)
  (set-face-background 'd-face-cc-debugging "lightgreen")
  (set-face-foreground 'd-face-cc-debugging "black")
  )

(progn
  (make-face  'd-face-cc-libd)
  (set-face-background 'd-face-cc-libd "white")
  (set-face-foreground 'd-face-cc-libd "brown")
  )

(progn
  (make-face  'd-face-cc-clib)
  (set-face-background 'd-face-cc-clib "white")
  (set-face-foreground 'd-face-cc-clib "brown")
  )

(progn
  (make-face  'd-face-cc-opengl)
  (set-face-background 'd-face-cc-opengl "white")
  (set-face-foreground 'd-face-cc-opengl "brown")
  )

(progn
  (make-face  'd-face-cc-illegal-type)
  (set-face-background 'd-face-cc-illegal-type "lightcyan")
  (set-face-foreground 'd-face-cc-illegal-type "red")
  )

(progn
  (make-face  'd-face-cc-digits)
  (set-face-background 'd-face-cc-digits "lightcyan")
  (set-face-foreground 'd-face-cc-digits "black")
  )

(progn
  (make-face  'd-face-makefile-dollar-dollar)
  (set-face-background 'd-face-makefile-dollar-dollar "lightgreen")
  (set-face-foreground 'd-face-makefile-dollar-dollar "black")
  )

(progn
  (make-face  'd-face-makefile-dollar-dollar-highlight)
  (set-face-background 'd-face-makefile-dollar-dollar-highlight "lightgreen")
  (set-face-foreground 'd-face-makefile-dollar-dollar-highlight "red")
  )

(progn
  (make-face 'd-face-el-d-stuff)
  (set-face-background 'd-face-el-d-stuff "white")
  (set-face-foreground 'd-face-el-d-stuff "lightblue")
  )

(d-quote
 132 ;; needed
 )

(progn
  (make-face 'd-face-el-quote)
  (set-face-background 'd-face-el-quote "white")
  (set-face-foreground 'd-face-el-quote "green")
  )

(progn
  (make-face 'd-face-makefile-dollar-dollar)
  (set-face-foreground 'd-face-makefile-dollar-dollar "black")
  (set-face-background 'd-face-makefile-dollar-dollar "lightgreen")
  )

(progn
  (make-face 'd-face-makefile-dollar-dollar-highlight)
  (set-face-foreground 'd-face-makefile-dollar-dollar-highlight "green")
  (set-face-background 'd-face-makefile-dollar-dollar-highlight "lightgreen")
  )

(progn
  ;;
  ;; NOTE: used by many modes
  ;;
  (make-face 'd-face-linefeed)
  (set-face-foreground 'd-face-linefeed "black")
  (set-face-background 'd-face-linefeed "lightgrey")
  )

(progn
  (make-face 'd-face-makefile-space)
  (set-face-foreground 'd-face-makefile-space "black")
  (set-face-background 'd-face-makefile-space "lightmagenta")
  )

;;(make-face 'd-face-makefile-tab)
;;(set-face-foreground 'd-face-makefile-tab "black")
;;(set-face-background 'd-face-makefile-tab "lightgrey")

(progn
  ;; 1
  (make-face 'd-face-dired-executable)
  (set-face-background 'd-face-dired-executable "white")
  (set-face-foreground 'd-face-dired-executable "green")
  )

(progn
  ;; 2
  (make-face 'd-face-dired-archives)
  (set-face-background 'd-face-dired-archives "white")
  (set-face-foreground 'd-face-dired-archives "lightred")
  )

(progn
  ;; 3
  (make-face 'd-face-dired-graphics)
  (set-face-background 'd-face-dired-graphics "white")
  (set-face-foreground 'd-face-dired-graphics "lightmagenta")
  )

(progn
  ;; 4
  (make-face 'd-face-dired-movies)
  (set-face-background 'd-face-dired-movies "lightmagenta")
  (set-face-foreground 'd-face-dired-movies "white")
  )

(progn
  ;; 5
  (make-face 'd-face-dired-sounds)
  (set-face-background 'd-face-dired-sounds "white")
  (set-face-foreground 'd-face-dired-sounds "brown")
  )

(progn
  ;; 6
  (make-face 'd-face-dired-binaries)
  (set-face-background 'd-face-dired-binaries "white")
  (set-face-foreground 'd-face-dired-binaries "brown")
  )

(progn
  ;; 8
  (make-face 'd-face-dired-text)
  (set-face-background 'd-face-dired-text "lightgrey")
  (set-face-foreground 'd-face-dired-text "black")
  )

(progn
  ;; 9
  (make-face 'd-face-dired-text)
  (set-face-background 'd-face-dired-text "lightgrey")
  (set-face-foreground 'd-face-dired-text "black")
  )

(progn
  ;; 10
  (make-face 'd-face-dired-web)
  (set-face-foreground 'd-face-dired-web "black")
  (set-face-background 'd-face-dired-web "yellow")
  )

(progn
  ;; 11
  (make-face 'd-face-dired-unimportant)
  (set-face-foreground 'd-face-dired-unimportant "lightgrey")
  )

(set-face-background 'region "lightcyan")

(make-face 'diary-face)
(set-face-foreground 'diary-face "lightblue")

(set-face-background 'bold "white")
(set-face-foreground 'bold "lightred")

(set-face-background 'italic "white")
(set-face-foreground 'italic "green")

(set-face-background 'underline "white")
(set-face-foreground 'underline "lightblue")

(make-face 'info-xref)
(set-face-background 'info-xref "lightcyan")
(set-face-foreground 'info-xref "black")

(make-face 'info-node)
(set-face-background 'info-node "lightgreen")
(set-face-foreground 'info-node "black")

;;(load-library "simple")

(defun delete-trailing-whitespace ()
  "Davin's function borrowed from simple.el"
  (interactive "*")
  (save-match-data
    (save-excursion
      (goto-char (point-min))
      (while (re-search-forward "\\s-$" nil t)
	(skip-syntax-backward "-" (save-excursion (forward-line 0) (point)))
	;; Don't delete formfeeds, even if they are considered whitespace.
	(save-match-data
	  (if (looking-at ".*\f")
	      (goto-char (match-end 0))))
	(delete-region (point) (match-end 0))))))

;;(safe-require 'subr)
;;(load-library "subr")

(provide 'd-dos-fonts)
