#! /bin/sh
# Testing of printf.
# Copyright (C) 2000-2014 Free Software Foundation, Inc.
# This file is part of the GNU C Library.

# The GNU C Library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.

# The GNU C Library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public
# License along with the GNU C Library; if not, see
# <http://www.gnu.org/licenses/>.

set -e

common_objpfx=$1; shift
test_program_prefix=$1; shift

status=0

${test_program_prefix} \
  ${common_objpfx}stdio-common/tst-printf \
  > ${common_objpfx}stdio-common/tst-printf.out || status=1

cat <<'EOF' |
%.4x:	`0012'
%04x:	`0012'
%4.4x:	`0012'
%04.4x:	`0012'
%4.3x:	` 012'
%04.3x:	` 012'
%.*x:	`0012'
%0*x:	`0012'
%*.*x:	`0012'
%0*.*x:	`0012'
bad format:	"%b"
nil pointer (padded):	"     (nil)"
decimal negative:	"-2345"
octal negative:	"37777773327"
hex negative:	"fffff6d7"
long decimal number:	"-123456"
long octal negative:	"37777773327"
long unsigned decimal number:	"4294843840"
zero-padded LDN:	"-000123456"
left-adjusted ZLDN:	"-123456   "
space-padded LDN:	"   -123456"
left-adjusted SLDN:	"-123456   "
zero-padded string:	"    Hi, Z."
left-adjusted Z string:	"Hi, Z.    "
space-padded string:	"    Hi, Z."
left-adjusted S string:	"Hi, Z.    "
null string:	"(null)"
limited string:	"Good morning, Doctor C"
e-style >= 1:	"1.234000e+01"
e-style >= .1:	"1.234000e-01"
e-style < .1:	"1.234000e-03"
e-style big:	"1.000000000000000000000000000000000000000000000000000000000000e+20"
e-style == .1:	"1.000000e-01"
f-style >= 1:	"12.340000"
f-style >= .1:	"0.123400"
f-style < .1:	"0.001234"
g-style >= 1:	"12.34"
g-style >= .1:	"0.1234"
g-style < .1:	"0.001234"
g-style big:	"100000000000000000000"
 0.10000
 0.10000
x0.5000x
0x1
something really insane: 1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
   4.94066e-324
|      0.0000|  0.0000e+00|           0|
|      1.0000|  1.0000e+00|           1|
|     -1.0000| -1.0000e+00|          -1|
|    100.0000|  1.0000e+02|         100|
|   1000.0000|  1.0000e+03|        1000|
|  10000.0000|  1.0000e+04|       1e+04|
|  12345.0000|  1.2345e+04|   1.234e+04|
| 100000.0000|  1.0000e+05|       1e+05|
| 123456.0000|  1.2346e+05|   1.235e+05|
snprintf ("%30s", "foo") == 30, "                   "
snprintf ("%.999999u", 10) == 999999

Formatted output test
prefix  6d      6o      6x      6X      6u
%-+#0 |-123   |0377   |0xff   |0XFF   |4294967295 |
 %-+# |-123   |0377   |0xff   |0XFF   |4294967295 |
 %-+0 |-123   |377    |ff     |FF     |4294967295 |
  %-+ |-123   |377    |ff     |FF     |4294967295 |
 %-#0 |-123   |0377   |0xff   |0XFF   |4294967295 |
  %-# |-123   |0377   |0xff   |0XFF   |4294967295 |
  %-0 |-123   |377    |ff     |FF     |4294967295 |
   %- |-123   |377    |ff     |FF     |4294967295 |
 %+#0 |-00123 |000377 |0x00ff |0X00FF |4294967295 |
  %+# |  -123 |  0377 |  0xff |  0XFF |4294967295 |
  %+0 |-00123 |000377 |0000ff |0000FF |4294967295 |
   %+ |  -123 |   377 |    ff |    FF |4294967295 |
  %#0 |-00123 |000377 |0x00ff |0X00FF |4294967295 |
   %# |  -123 |  0377 |  0xff |  0XFF |4294967295 |
   %0 |-00123 |000377 |0000ff |0000FF |4294967295 |
    % |  -123 |   377 |    ff |    FF |4294967295 |
    (null)
(null)    
1.234568e+06 should be 1.234568e+06
1234567.800000 should be 1234567.800000
1.23457e+06 should be 1.23457e+06
123.456 should be 123.456
1e+06 should be 1e+06
10 should be 10
0.02 should be 0.02
Test ok.
sprintf (buf, "%07Lo", 040000000000ll) = 40000000000
printf ("%hhu", 257) = 1
printf ("%hu", 65537) = 1
printf ("%hhi", 257) = 1
printf ("%hi", 65537) = 1
printf ("%1$hhu", 257) = 1
printf ("%1$hu", 65537) = 1
printf ("%1$hhi", 257) = 1
printf ("%1$hi", 65537) = 1
--- Should be no further output. ---
EOF
cmp - ${common_objpfx}stdio-common/tst-printf.out > /dev/null 2>&1 ||
cat <<'EOF' |
%.4x:	`0012'
%04x:	`0012'
%4.4x:	`0012'
%04.4x:	`0012'
%4.3x:	` 012'
%04.3x:	` 012'
%.*x:	`0012'
%0*x:	`0012'
%*.*x:	`0012'
%0*.*x:	`0012'
bad format:	"%b"
nil pointer (padded):	"     (nil)"
decimal negative:	"-2345"
octal negative:	"37777773327"
hex negative:	"fffff6d7"
long decimal number:	"-123456"
long octal negative:	"1777777777777777773327"
long unsigned decimal number:	"18446744073709428160"
zero-padded LDN:	"-000123456"
left-adjusted ZLDN:	"-123456   "
space-padded LDN:	"   -123456"
left-adjusted SLDN:	"-123456   "
zero-padded string:	"    Hi, Z."
left-adjusted Z string:	"Hi, Z.    "
space-padded string:	"    Hi, Z."
left-adjusted S string:	"Hi, Z.    "
null string:	"(null)"
limited string:	"Good morning, Doctor C"
e-style >= 1:	"1.234000e+01"
e-style >= .1:	"1.234000e-01"
e-style < .1:	"1.234000e-03"
e-style big:	"1.000000000000000000000000000000000000000000000000000000000000e+20"
e-style == .1:	"1.000000e-01"
f-style >= 1:	"12.340000"
f-style >= .1:	"0.123400"
f-style < .1:	"0.001234"
g-style >= 1:	"12.34"
g-style >= .1:	"0.1234"
g-style < .1:	"0.001234"
g-style big:	"100000000000000000000"
 0.10000
 0.10000
x0.5000x
0x1
something really insane: 1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
5.87747175411143754e-39
   4.94066e-324
|      0.0000|  0.0000e+00|           0|
|      1.0000|  1.0000e+00|           1|
|     -1.0000| -1.0000e+00|          -1|
|    100.0000|  1.0000e+02|         100|
|   1000.0000|  1.0000e+03|        1000|
|  10000.0000|  1.0000e+04|       1e+04|
|  12345.0000|  1.2345e+04|   1.234e+04|
| 100000.0000|  1.0000e+05|       1e+05|
| 123456.0000|  1.2346e+05|   1.235e+05|
snprintf ("%30s", "foo") == 30, "                   "
snprintf ("%.999999u", 10) == 999999

Formatted output test
prefix  6d      6o      6x      6X      6u
%-+#0 |-123   |0377   |0xff   |0XFF   |4294967295 |
 %-+# |-123   |0377   |0xff   |0XFF   |4294967295 |
 %-+0 |-123   |377    |ff     |FF     |4294967295 |
  %-+ |-123   |377    |ff     |FF     |4294967295 |
 %-#0 |-123   |0377   |0xff   |0XFF   |4294967295 |
  %-# |-123   |0377   |0xff   |0XFF   |4294967295 |
  %-0 |-123   |377    |ff     |FF     |4294967295 |
   %- |-123   |377    |ff     |FF     |4294967295 |
 %+#0 |-00123 |000377 |0x00ff |0X00FF |4294967295 |
  %+# |  -123 |  0377 |  0xff |  0XFF |4294967295 |
  %+0 |-00123 |000377 |0000ff |0000FF |4294967295 |
   %+ |  -123 |   377 |    ff |    FF |4294967295 |
  %#0 |-00123 |000377 |0x00ff |0X00FF |4294967295 |
   %# |  -123 |  0377 |  0xff |  0XFF |4294967295 |
   %0 |-00123 |000377 |0000ff |0000FF |4294967295 |
    % |  -123 |   377 |    ff |    FF |4294967295 |
    (null)
(null)    
1.234568e+06 should be 1.234568e+06
1234567.800000 should be 1234567.800000
1.23457e+06 should be 1.23457e+06
123.456 should be 123.456
1e+06 should be 1e+06
10 should be 10
0.02 should be 0.02
Test ok.
sprintf (buf, "%07Lo", 040000000000ll) = 40000000000
printf ("%hhu", 257) = 1
printf ("%hu", 65537) = 1
printf ("%hhi", 257) = 1
printf ("%hi", 65537) = 1
printf ("%1$hhu", 257) = 1
printf ("%1$hu", 65537) = 1
printf ("%1$hhi", 257) = 1
printf ("%1$hi", 65537) = 1
--- Should be no further output. ---
EOF
cmp - ${common_objpfx}stdio-common/tst-printf.out > /dev/null 2>&1 ||
{
  status=1
  echo "*** output comparison failed"
}

exit $status
