/* -*-c-*- ---------------- mixgtk_cmd_dispatcher.h :
 * functions to access the command dispatcher
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: <01/03/09 22:08:08 jose>
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#ifndef MIXGTK_CMD_DISPATCHER_H
#define MIXGTK_CMD_DISPATCHER_H

#include <mixlib/mix_vm.h>
#include "mixgtk_widgets.h"

/* initialise the command dispatcher */
extern gboolean
mixgtk_cmd_dispatcher_init (void);

/* dispatch an externally provided command */
extern void
mixgtk_cmd_dispatcher_dispatch (const gchar *command);

/* get times */
extern void
mixgtk_cmd_dispatcher_get_times (gint *uptime, gint *progtime, gint *laptime);

/* get the underlying vm */
extern mix_vm_t *
mixgtk_cmd_dispatcher_get_vm (void);

/* make gtk signal callbacks accessible to glade */
/* new command handler */
extern void
on_mixvm_cmd_entry_activate (GtkWidget *w, gpointer e);



#endif /* MIXGTK_CMD_DISPATCHER_H */

