# generates an entire sheet of pictures
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.

set photodir "/nfs/capa2/photos/eps"
set blankpic "/nfs/capa2/photos/eps/empty.eps"
set sectionlimit 26
set fileId [open classl]
proc printheader {} {
	puts {\documentstyle[12pt,,epsf]{article}}
	puts {\textheight 10.5in  }
	puts {\oddsidemargin = -0.57in}
	puts {\evensidemargin = -0.57in}
	puts {\textwidth= 7.8in } 
	puts {\begin{document}}
	puts {\voffset=-1.7in}
	puts {\noindent}
}
proc printfooter {} {
	puts {\end{document}}
}

printheader
set num 0
while {1} {
	incr num
	set line [gets $fileId]
	if { [eof $fileId] } { break }
	scan [lindex $line 2] %d section
	if { $section > $sectionlimit } { continue }
	set stuid [lindex $line 3]
	set lastname [lindex $line 4]
	set firstname [lindex $line 5]
	set firstchar [string index $firstname 0]
	puts -nonewline "\\parbox\{1.32in\}\{\\framebox\{\\noindent \\epsfxsize=1.0 in \\epsffile\{"
#	puts "\n$stuid [file join $photodir $stuid.eps] [file readable [file join $photodir $stuid.eps]]"

	if {[file readable [file join $photodir $stuid.eps]]} {
		puts -nonewline [file join $photodir $stuid.eps]
	} else {
		puts -nonewline $blankpic
	}
	puts -nonewline "\}\}\\\\$lastname $firstchar \}"
	if { $num > 6 } {
		puts "\\\\"
		set num 0
	} else {
		puts ""
	}
}
printfooter
close $fileId
