# Copyright (c) 2008, 2009, 2010 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

Name: sipwitch
Summary: A secure peer-to-peer VoIP server for the SIP protocol
Version: 1.9.2
Release: 0%{?dist}
License: GPLv3+
URL: http://www.gnu.org/software/sipwitch
Group: Applications/Communications
Source: http://dev.gnutelephony.org/dist/tarballs/sipwitch-%{version}.tar.gz
BuildRequires: ucommon-devel >= 6.0.0
BuildRequires: libeXosip2-devel >= 3.0.0
BuildRequires: avahi-devel
BuildRequires: openssl-devel
BuildRequires: systemd-devel >= 200
BuildRequires: cmake
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd
Requires: %{name}-runtime%{?_isa} = %{version}-%{release}

%package runtime
Group: Development/Libraries
Summary: Runtime library support for sipwitch

%package devel
Requires: ucommon-devel%{?_isa} >= 6.0.0
Requires: %{name}-runtime%{?_isa} = %{version}-%{release}
Requires: libeXosip2-devel%{?_isa} >= 3.0.0
Group: Development/Libraries
Summary: Headers for building sipwitch plugins

%package cgi
Requires: %{name}%{?_isa} = %{version}-%{release}
Group: Applications/CGI
Summary: cgi web interface to control sipwitch server

%package plugin-zeroconf
Requires: %{name}%{?_isa} = %{version}-%{release}
Summary: Zeroconf plugin for sipwitch

%package plugin-scripting
Requires: %{name}%{?_isa} = %{version}-%{release}
Summary: Scripting plugin for sipwitch

%package plugin-forward
Requires: %{name}%{?_isa} = %{version}-%{release}
Summary: Forward registration and routing plugin

%package plugin-subscriber
Requires: %{name}%{?_isa} = %{version}-%{release}
Summary: Subscriber gateway plugin for sipwitch

%description
GNU SIP Witch is a secure peer-to-peer VoIP server.  Calls can be made even
behind NAT firewalls, and without needing a service provider.  SIP Witch can
be used on the desktop to create bottom-up secure calling networks as a
free software alternative to Skype.  SIP Witch can also be used as a stand-
alone SIP-based office telephone server, or to create secure VoIP networks
for an existing IP-PBX such as Asterisk, FreeSWITCH, or Yate.

%description devel
Header files for building plugins that interface with sipwitch. This might be
used for externally creating sipwitch modules, though normally modules are
found or added to the core distribution directly.  This may also be for
developing external application services which need to communicate with a
running sipwitch daemon instance.

%description runtime
Runtime library required for sipwitch development and for using the server.
This is available as a separate package so that one building sipwitch plugins
with the required devel package does not also require installing a server
image.

%description cgi
This package offers a means to perform remote management of a sipwitch
server using the cgi interface of an installed web server.  The primary
service this offers is xmlrpc access to sipwitch shared memory and
control interfaces in a manner analgolous to the sipwitch command utility.

%description plugin-zeroconf
This plugin activates zeroconf network services for sipwitch and publishes
sipwitch as a sip server.

%description plugin-scripting
This plugin enables shell scripting in connection with specific sipwitch
events.

%description plugin-forward
This plugin enables forwarding of registration requests and destination routes
for unknown numbers so that one can create a "secure" peer to peer media
domain managed by sipwitch and still access an "insecure" b2bua based ip-pbx.

%description plugin-subscriber
This module is meant to eventually offer generic support for premise
routers when used by providers to offer sip/voip service to a subscriber.
It offers rtp proxying and routing based on the assumption that all calls
will be handed off to an external voip provider and automatic rtp
proxy bridging between a subscribers local subnet and an isp.  In theory
this would be deployed in an isp supplied premise router to enable a
local user to subscribe a series of local softphone/sip devices with a
remote voip service provider.

%prep
%setup -q
%build
%cmake \
      -DSYSCONFDIR=%{_sysconfdir} \
      -DINSTALL_MANDIR=%{_mandir} \
      -DINSTALL_INCLUDEDIR=%{_includedir} \
      -DINSTALL_BINDIR=%{_bindir} \
      -DINSTALL_SBINDIR=%{_sbindir} \
      -DINSTALL_LIBEXEC=%{_libexecdir} \
      -DINSTALL_LIBDIR=%{_libdir} \
	  -DINSTALL_CGIBIN=/var/www/cgi-bin \
	  -DINSTALL_UNITDIR=%{_unitdir} \
      -DSYSTEM_CONFIG:BOOL=TRUE \
	  .

%{__make} %{?_smp_mflags}

%install
%{__make} DESTDIR=%{buildroot} install

%files
%doc README COPYING NEWS FEATURES SUPPORT TODO NOTES AUTHORS MODULES ChangeLog
%{_mandir}/man1/sipwitch.1*
%{_mandir}/man1/sippasswd.1*
%{_mandir}/man1/sipquery.1*
%{_mandir}/man8/sipw.8*
%{_sbindir}/sipw
%{_bindir}/sipquery
%{_bindir}/sipwitch
%attr(04755,root,root) %{_bindir}/sippasswd
%dir %{_libdir}/sipwitch
%config(noreplace) %{_sysconfdir}/logrotate.d/sipwitch
%attr(0755,root,root) %{_unitdir}/sipwitch.service
%attr(0755,root,root) %{_sysconfdir}/cron.hourly/sipwitch
%attr(0775,root,root) %dir %{_sysconfdir}/sipwitch.d
%attr(0664,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.conf
%attr(0664,root,root) %config(noreplace) %{_sysconfdir}/default/sipwitch
%attr(0664,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.d/*.xml*

%files cgi
%{_mandir}/man8/sipwitch.cgi.8*
/var/www/cgi-bin/sipwitch.cgi

%files runtime
%{_libdir}/*.so.*

%files plugin-zeroconf
%{_libdir}/sipwitch/zeroconf.so

%files plugin-forward
%{_libdir}/sipwitch/forward.so

%files plugin-scripting
%{_libdir}/sipwitch/scripting.so

%files plugin-subscriber
%{_libdir}/sipwitch/subscriber.so

%files devel
%{_libdir}/*.so
%{_includedir}/sipwitch/
%{_libdir}/pkgconfig/*.pc

%post runtime
/sbin/ldconfig

%post
%systemd_post sipwitch.service

%preun
%systemd_preun sipwitch.service

%postun
%systemd_postun_with_restart sipwitch.service 

%postun runtime
/sbin/ldconfig

%changelog

