#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: gnome_menu.py 9957 2009-10-11 18:55:59Z reinhard $
#
"""
Install a GNOME menu structure based on a GPD file.

Optional parameters::
  system[="/path/to/gnomedir]   -- Install system-wide (needs root access)
  menu="Menu/Structure"         -- Menu structure... by default,
                                  "GNUe Apps/" + the to process's description
  quiet                         -- Turn on quiet mode
"""

import string, sys, os


def run(processes, args):
  arguments = {}
  for argument in args:
    if '=' in argument:
      param, value = string.split(argument,'=',1)
    else:
      param, value = (argument, "")
    arguments[param] = value
    
  if not arguments.has_key('quiet'):
    print "Creating GNOME menu structure..."
  
  directory = "~/.gnome2/vfolders/applications/"
  if arguments.has_key('menu'):
    directory = os.path.join(directory,arguments['menu'])
  else:
    directory = os.path.join(directory,'GNUe Apps')

  directory = os.path.expanduser(directory)

  buildMenu(processes, directory)


def buildMenu(process, location):
  description = ""
  if process._type == 'GNProcesses':
    description = process.title or process.description

  directory = os.path.join(location, string.replace(description,'/',''))
  if not os.path.exists(directory):
    os.makedirs(directory)

  outfile = open(os.path.join(directory,'.directory'),'w')
  outfile.write("""\
[Desktop Entry]
Name=%s
Icon=gnome-folder.png
Terminal=false
MultipleArgs=false
Type=Directory
""" % description)

  for child in process._children:
    if child._type == 'GNStep':
      makeLinkFile(directory, child)
    else:
      buildMenu(child, directory)


def makeLinkFile(directory, step):
  outfile=open(os.path.join(directory, string.replace(step.title, "/", "") + \
      '.desktop'), 'w')

  if step.type == 'form':
    command = gConfig("RunFormCommand", section='navigator')
    icon = "gnome-applications.png"
  elif step.type == 'report':
    command = gConfig("RunReportCommand", section='navigator')
    icon = "gnome-note.png"

  outfile.write("""\
[Desktop Entry]
Version=AddLater
Encoding=UTF-8
Type=Application
Exec=%(executable)s %(location)s
Icon=%(icon)s
Terminal=false
Name=%(description)s
Comment=%(description)s
TerminalOptions=
MultipleArgs=false
""" % { 'executable': command,
        'icon': icon,
        'description': step.title,
        'location': step.location })

  outfile.close()
