#!env python
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2009 Free Software Foundation
#
# FILE:
# mailmerge.py
#
# DESCRIPTION:
# Base file for the GNUe Reports merge demos
#
# NOTES:
# Not intended to be directly run. Use merge-* instead.
#

import string, sys, re
import xml.sax

class MergeBase(xml.sax.ContentHandler):
  FIELD_ENCLOSURE = '::'
  NEWPAGE = "\p"
  HEAD_DELIMITER = r"^"
  TAIL_DELIMITER = r"$"
  REGEX = r"\A(.*"            \
          + HEAD_DELIMITER \
          + r")(.+)("           \
          + TAIL_DELIMITER \
          + r".*)\Z"

  COMMENT_BEGIN = "#"
  COMMENT_END = "\n"
  MULTILINE_COMMENTS = 0

  def __init__(self):
    self.fieldre = re.compile("%s(\\w+)%s" % \
          (self.FIELD_ENCLOSURE, self.FIELD_ENCLOSURE))

    self.__dict = {'values': None, 'name': None, 'field': False, 'string': ""}
    
  def escape(self, s):
    return string

  def printComment (self, out, comment):
    if self.COMMENTABLE:
      if not self.MULTILINE_COMMENTS:
        comments = string.split(comment,"\n")
      else:
        comments=[comment];

      out.write("%s%s%s" % (self.COMMENT_BEGIN,
           string.join(comments, self.COMMENT_END + self.COMMENT_BEGIN),
           self.COMMENT_END))


  def merge (self, data, template, output):
    self.printComment (output, "\n"
                  "================================\n"
                  "This file was generated from the\n"
                  "GNUe Reports / MailMerge Sample.\n"
                  "(http://www.gnue.org/)\n"
                  "================================\n")

    tmpl = string.join(template.readlines(),"")

    reg = re.search(self.REGEX, tmpl, re.DOTALL)
    if reg == None:
      print "\nUnable to parse the requested template file.\n"
      sys.exit()

    header, self.repeating, footer = reg.groups()
    self.output = output
    self.recordCount = 1
    self.newPage = 0

    output.write(header)
    self.printComment(output,
     "GNUe MailMerge [%s]:  Start of Repeating Section"%self.NAME)

    # Create a parser
    parser = xml.sax.make_parser()

    # Tell the parser to use our handler
    parser.setContentHandler(self)
    parser.parse(data)

    # Print out the footer text
    self.printComment(output,
     "GNUe MailMerge [%s]:  End of Repeating Section"%self.NAME)
    output.write(footer)


  # XML handling stuff
  def startElement(self, name, attrs):
    self.__dict['field'] = False
    if name == "field":
       self.__dict['field'] = True
       #       self.values[string.lower(attrs['name'])] = "temp" #attrs['value']
       self.__dict['values'] = self.values
       self.__dict['name'] = string.lower(attrs['name'])

    elif name == "record":
      self.values = {}
      if self.newPage:
        self.output.write(self.NEWRECORD)
      self.newPage = 1

  def characters(self, ch):
    
    if self.__dict['field'] == True:
      self.__dict['string'] = self.__dict['string'] + ch
  
  def endElement(self, name):
    if name == "record":
      self.printComment (self.output,
        "GNUe MailMerge [%s]:  Record #%d" % (self.NAME, self.recordCount))

      self.output.write(self.fieldre.sub(self.getFieldValue, self.repeating))

      self.recordCount = self.recordCount + 1

    elif name == "field":
      self.__dict['values'][self.__dict['name']] = self.__dict['string'].strip()
      self.__dict['string'] = ""
      
  def getFieldValue(self, matchObject):
    name = string.lower(matchObject.group(1))
    try:
      return self.escape(self.values[name])
    except KeyError:
      return ""



if __name__ == "__main__":
  print "\nRun one of the merge-* samples.\n"