# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# $Id: csv.py 9958 2009-10-11 18:56:59Z reinhard $
#
# DESCRIPTION:
# Transforms adapter for direct
#
# NOTES:
#

class DirectFormatter:

  def __init__(self, destination, stylesheet, options={}):
    self.dest = destination
    self.options = options
    try:
      self.encoding = options['encoding']
    except:
      self.encoding = gConfig('textEncoding')

  def writeout(self, text):
    self.dest.write(text.encode(self.encoding,'replace'))

  def BeginReport(self):
    pass

  def EndReport(self):
    pass

  def BeginReportTitle(self):
    pass

  def EndReportTitle(self, reporttitle):
    pass

  def BeginSection(self):
    pass

  def EndSection(self):
    pass

  def BeginSectionTitle(self):
    pass

  def EndSectionTitle(self, sectiontitle):
    pass

  def BeginTable(self):
    pass

  def EndTable(self):
    pass

  def BeginTableHead(self):
    self._head = []

  def EndTableHead(self):
    self.writeout('%s\n' % ','.join(self._head))

  def BeginColHead(self):
    pass

  def EndColHead(self, colhead, width, alignment=None):
    self._head.append('"%s"' % colhead)

  def BeginRow(self, rowtype=None):
    self._row = []

  def EndRow(self):
    self.writeout('%s\n' % ','.join(self._row))

  def BeginCol(self):
    pass

  def EndCol(self, col, index):
    self._row.append('"%s"' % col)




