#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# FILE:
# general/libxslt/Adapter.py
#
# DESCRIPTION:
# Transforms adapter for libxslt (http://www.xmlsoft.org/XSLT/index.html)
#
# NOTES:
#

import sys, tempfile

try:
  import libxslt,libxml2
except ImportError:
  print "Unable to load libxslt"
  print "On Debian just do a : apt-get install libxslt1-python2.2"
  print "For win32 go to http://users.skynet.be/sbi/libxml-python/"
  sys.exit()


from gnue.reports.base.GROutputAdapter import TransformAdapter as Base

class _MessageHandler:
  def write(self, msg):
    print 'message:', msg

class TransformAdapter(Base):

  def open(self):
    # We need a temp file at the moment
    # TODO: try to stop using the temp file

    self.input, self.infile = self.createTempFile()
    return self.input

  def close(self):

    # We are finished with the intermediate file, so
    # close in order for sablotron to be able to open it.
    self.input.close()

    # Get a file for output from the destination adapter.
    outfile = self.destination.getOutputFile()

    # Get the name of the transform script
    try:
      xslfile = self.parameters['template']
    except KeyError:
      raise "Filter configuration file is missing the 'template=' parameter"

    # load stylesheet and parse it
    styledoc = libxml2.parseFile(xslfile)
    style = libxslt.parseStylesheetDoc(styledoc)

    # load input file
    doc = libxml2.parseFile(self.infile)

    # do the processing
    result = style.applyStylesheet(doc, None)

    # write the result
    style.saveResultToFilename(outfile, result, 0)

    # some cleanup
    style.freeStylesheet()
    doc.freeDoc()
    result.freeDoc()

    try:
      mimetype = self.parameters['mimetype']
    except:
      mimetype = 'text/plain'


    # Let the destination adapter do its thing
    self.destination.close(mimetype=mimetype)

    # clean up our temp files
    self.deleteTempFile(self.infile)

