#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# FILE:
# GRReportInfo.py
#
# DESCRIPTION:
# Class that loads a report and returns information about it
#
# NOTES:
#


from GRParser import loadFile
from GRFilters import GRFilterConfig


class GRReportInfo:

  def __init__(self, location):
    self.report = loadFile(location, initialize=0)

  def getTitle(self, default="Untitled Report"):
    try:
      return self.report.title
    except AttributeError:
      return default


  def getDescription(self, default="Untitled Report"):
    try:
      return self.report.description
    except AttributeError:
      return default


  def getParameters(self):
    parameters = None
    for child in self.report._children:
      if child._type == "GRParameters":
        parameters = child
        break

    params = []
    if parameters:
      for param in parameters._children:
        atts = {}
        for attr in param.__dict__.keys():
          if attr[0] != '_':
            atts[attr] = param.__dict__[attr]

        params.append(atts)

    return params


  def getNamespace(self):
    layout = None
    for child in self.report._children:
      if child._type == "GRLayout":
        layout = child
        break

    try:
      return layout._findNamespace(layout)
    except AttributeError:
      return ""


  def getFilters(self):
    namespace = self.getNamespace()

    config = GRFilterConfig()
    return config.getFilters(namespace)


