#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# GRLayout.py
#
# DESCRIPTION:
# Classes related to the Layout section
#
# NOTES:
#


from gnue.common.definitions.GObjects import *
from gnue.common.apps import GDebug
from gnue.common.datasources import GConditions
from gnue.common.logic.GTrigger import GTrigger,GTriggerExtension

import string
from xml.sax import saxutils
from GRLayoutElement import GRLayoutElement


############################################################
#
# Any elements contained within a <layout> element
# that can themselves be containers
#
class ContainerElement (GRLayoutElement):
  def __init__(self, parent=None, type='GRContainerElement'):
    GRLayoutElement.__init__(self, parent, type=type)
    # TODO: remove.. this is for debugging
    self._name = "untitled"


  # Process all children, handling GRSections properly
  def processChildren(self, dest, mapper,
                      isfirst, islast, firstSection, nextSection):

    first = isfirst or self._type == 'GRSection'

    while 1:
      if self._type == 'GRSection':
        self.processTrigger('On-Process')

      for child in self._children:
        if child._type == "_content_":
          dest.write(child.getContent().encode(gConfig('textEncoding'),'replace'))
        elif isinstance(child, GRLayoutElement) and child._enabled:
          # Handle GRSections specially as
          # they require extra logic
          if child._type == 'GRSection':
            # If this is the top-most section for a datasource,
            # it needs to be called with processAsController.
            if child._mymapper and child._mymapper.toplevel:

              assert gDebug(10, "Calling new controlling section")
              child.processAsController(dest, mapper)

            # ..otherwise call the GRSection's process method.
            else:
              nextSection = child.process(dest, mapper,isfirst=1,
                                          islast=(nextSection == None) or \
                                          (nextSection._name not in (child._childSections)),
                                          firstSection=firstSection, nextSection=nextSection)
          # Don't allow the processing to enter trigger objects
          else:
            # Handle the layout element.
            nextSection = child.process(dest, mapper, first, islast,
                                        firstSection, nextSection)

      first = 0

      if nextSection == self:
        firstSection, nextSection = self.getGotos(mapper)
        islast = (nextSection == None)
      else:
        break

    return nextSection


  #
  #  getAncestorWithSource()
  #
  def getAncestorWithSource(self, source):
    if self.getParent ()._type == 'GRSection':
      return self.getParent ().getAncestorWithSource(source)
    else:
      return None
