/*
Copyright (C) 1995 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This software is free; you can redistribute it and/or modify it under the 
terms of the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _mVector_h_
#define _mVector_h_

#include<iostream.h>
#include<defalloc.h>
#include"array_store.h"

#define _START_ 1
#define _COMP_ <=
#define _OBJECT_ mVector

#undef _MEMBER_TEMPLATES_

template<class T,class S> class mMatrix;

template<class T,class S = allocator<T> >
class  mVector
{
public:
  typedef S::pointer            container_type;
  typedef T                     value_type;
  typedef value_type&           reference;
  typedef const value_type&     const_reference;
  typedef S::size_type          size_type;

  mVector() : s_(0), p_(0), ps_(0) {}

  mVector(size_type n,const_reference a=value_type()) : s_(n), c_(S().allocate(n)) {
    p_=c_; ps_=s_;     // save original address
    --c_;       // indexing of array is one-offset
    for(size_type j=1;j<=size();j++) construct(&(c_[j]),a); }

  mVector(const mVector & v) : s_(v.s_), c_(v.c_), p_(0), ps_(0) {}

  ~mVector() { 
    for(size_type j=0;j<ps_;j++) destroy(&(p_[j]));
    S().deallocate(p_); 
} 

  reference operator()(size_type j) { return (reference)c_[j]; }
  value_type operator()(size_type j) const { return c_[j]; }
  container_type& container() { return c_; }
  const container_type& container() const { return c_; }

  size_type size() const { return s_; }
  void resize(size_type n) { s_=n; }
  void reserve(size_type n,const_reference a=value_type()) {
    this->~mVector(); 
    s_=n;
    c_=S().allocate(n);
    p_=c_;      // save original address
    ps_=s_;
    --c_;       // indexing of array is one-offset
    for(size_type j=1;j<=s_;j++) construct(&(c_[j]),a); }

  mVector & operator=(const_reference b) {
    for(size_type j=1;j<=size();j++) (*this)(j)=b;
    return (*this); }

#ifdef _MEMBER_TEMPLATES_
  template<class T2,class S2>
  mVector & operator=(const  mVector <T2,S2>& b) {
#else        NOT _MEMBER_TEMPLATES_
  mVector & operator=(const  mVector & b) {
#endif        NOT _MEMBER_TEMPLATES_
    for(size_type j=1;j<=size();j++) (*this)(j)=b(j);
    return (*this); }

friend class mMatrix<T,S>;

private:
  container_type c_,p_;
  size_type s_,ps_;
};        // End of class  mVector

#include"array_def.h"

#undef _START_
#undef _COMP_
#undef _OBJECT_

#endif       _mVector_h_

