// Declares some structs and functions for inclusion in C-files only.

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This file is part of the GNUSSL software package.  This package is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this distribution; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include<stddef.h>

struct c_double_array {
  size_t s_;
  double *data_;
};

struct c_double_vector {
  size_t s_;
  double *data_;
};

struct c_double_matrix {
  size_t r_;
  size_t c_;
  double *data_;
};

struct c_complex_array {
  size_t s_;
  struct c_complex *data_;
};

struct c_complex_vector {
  size_t s_;
  struct c_complex *data_;
};

struct c_complex_matrix {
  size_t r_;
  size_t c_;
  struct c_complex *data_;
};

size_t 
a_elem(size_t s); 

size_t 
v_elem(size_t s); 

size_t 
m_elem(size_t rows,size_t cols,size_t r,size_t c); 

