// The primary C-language interface file for the GNUSSL library.  This
// is the only file which should be included in C programs, and it declares
// both the necessary structs and functions.

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This file is part of the GNUSSL software package.  This package is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this distribution; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include<stddef.h>

struct c_complex 
{
  double re;
  double im;
};

#include"c_array.h"

typedef struct c_double_vector cdv_;
typedef struct c_double_matrix cdm_;

typedef struct c_complex_vector ccv_;
typedef struct c_complex_matrix ccm_;

void 
complex_gauss_jordan(ccm_ opm,ccm_ a,double tol,size_t full,size_t r,size_t c);

int 
complex_lud(ccm_ opm,size_t* swp,double tol);

void 
complex_lu_solve(ccm_ opm,ccm_ a,double tol); 

struct c_complex 
complex_determinant(ccm_ opm,double tol); 

void
complex_qrd(ccm_ opm,ccm_ q);

void 
complex_hessenberg(ccm_ opm,size_t record);

void 
complex_bidiag(ccm_ opm,size_t record);

void
complex_eigenvalues(ccm_ opm,double tol);

void
complex_svd(ccm_ opm,ccm_ u,cdv_ d,ccm_ v,double tol);

void
complex_singular_values(ccm_ opm,cdv_ sv,double tol);

size_t
complex_pseudo_inverse(ccm_ opm,ccm_ u,cdv_ sv,ccm_ v,double tol);

void
complex_mdotm(ccm_ a,ccm_ b,ccm_ r);

void
complex_mdotv(ccm_ a,ccv_ b,ccv_ r);

void
complex_vdotm(ccv_ a,ccm_ b,ccv_ r);
  
