// Defines some utility functions and constants 

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This file is part of the GNUSSL software package.  This package is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this distribution; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _utilities_h_
#define _utilities_h_

#include<float.h>
#include<sys/time.h>
extern "C" int gettimeofday(struct timeval *,struct timezone *);
#include<stddef.h>
#include<math.h>
#include<complex.h>
#include<mArray.h>
#include<mMatrix.h>

// uncomment this if you want to turn on exception handling.  Be warned that
// under gcc version 2.7.2 this can cause compilation crashes.  Code that
// successfully compiles appears to execute properly.
//#define EX_HANDLE 1

// These are for the plotting routines, and define the 8-bit greyscale 
// colors (0-GREY).  They should not need to be changed.
#define WIRE 0                       // wire color
#define BACKGROUND 255               // background color
#define GREY 255                     // max grey value
#define VP_TINY 1.0e-7               // a small value relative to 1

// These set default tolerances for linear algebra routines.  They may be 
// overridden by arguments to the functions, so there should be little 
// reason for changing them.
#define GJ_TINY (long double)1.0e-14    // test value for partial pivoting
#define SVD_TINY (long double)1.0e-14   // default value for numerical tolerance

// Maximum number of iterations in eigenvalue() and svd().  If it takes more
// than this, something is probably wrong unless the matrix is huge.
#define SVD_IT_MAX 10000

// Define some local functions, these are the functions which might
// need to be redefined for user-defined types. 
static float conj(const float &a) { return a; }
static double conj(const double &a) { return a; }
static long double conj(const long double &a) { return a; }
static float norm(const float &a) { return a*a; }
static double norm(const double &a) { return a*a; }
static long double norm(const long double &a) { return a*a; }
static float real(const float &a) { return a; }
static double real(const double &a) { return a; }
static long double real(const long double &a) { return a; }
static float imag(const float &a) { return 0.0; }
static double imag(const double &a) { return 0.0; }
static long double imag(const long double &a) { return 0.0; }

class
gError {
public:
  char* message;         // the error message

  gError() : message(0) {}
  gError(char *msg) : message(msg) {}
};

class
gSingular : public gError {
public:
  long double tol;         // the tolerance used to judge the matrix singular
  gSingular() : tol(0.0) {}
  gSingular(double t) : tol(t) {}
  gSingular(double t,char *msg) : tol(t), gError(msg) {}
};

class
gSize : public gError {
public: 
  unsigned rsize,csize;    // the size of the matrix which was wrong
  gSize() : rsize(0), csize(0) {}
  gSize(unsigned r,unsigned c) : rsize(r), csize(c) {}
  gSize(unsigned r,unsigned c,char *msg) : rsize(r), csize(c), gError(msg) {}
};

class
gIteration : public gError {
public:
  unsigned iter;           // the iterations used
  gIteration() : iter(0) {}
  gIteration(unsigned t) : iter(t) {}
  gIteration(unsigned t,char *msg) : iter(t), gError(msg) {}
};

#endif

