// tests the linear algebra functions based on Householder reflections
// and Givens rotations

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This software is free; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
You should have received a copy of the GNU General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include<complex.h>
#include<mMatrix.h>
#include<instance.h>
#include<lin_alg.h>
#include<stl.h>

template class mVector<complex<double>,mu_allocator<unary_allocator<allocator<complex<double> >,complex<double> (*)(const complex<double> &)>,allocator<complex<double> > > >;

template class mVector<complex<double>,mu_allocator<rc_allocator<mi_allocator<allocator<complex<double> >,mu_allocator<scalar_allocator<complex<double> >,allocator<complex<double> > > > >,allocator<complex<double> > > >;

bool
gt(double_complex a,double_complex b)
{
// comparison function for sorting
  return abs(a)>abs(b);
}

int main(int argc,char **argv) {
  int dim=atoi(argv[1]);
  mMatrix<double_complex,allocator<double_complex> > a(dim,dim),i(dim,dim);
  mVector<double_complex,allocator<double_complex> > p(dim),q(dim),z(dim);
  srand(1);              // seed the random # generator with a known value
  double maxr=(double)0x0fffffff;
  for(int r=1;r<=dim;r++) {  // set a to a random matrix, i to the identity
    for(int c=1;c<=dim;c++) {
      a(r,c)=double_complex(rand()/maxr,rand()/maxr);
      i(r,c)=0.0;
    }
    i(r,r)=1.0;
    p(r)=double_complex(rand()/maxr,rand()/maxr);   // and p to a random vector
  }
  mMatrix<double_complex,allocator<double_complex> > b(dim,dim),c(dim,dim);
  b=a;        // copy the random matrix and the identity
  c=i;
  cout << "Test mMatrix is random complex, with "<< dim << " rows and columns\n";
  mMatrix<double_complex,allocator<double_complex> > u(dim,dim),v(dim,dim);
  u=i;                // identity matrices
  v=i;
  mVector<double,allocator<double> > sv1(dim);

  cout << "Eigenvalues and eigenvectors:\n";
  cout << "QR algorithm: \n";
  b=a;         // reset b
  eigenvalues(b,0.0);     // calculate all eigenvalues
//  q=b.diagonal();
assign(b.diagonal(),q);
  sort(&(q(1)),&(q(2)),gt);     // reorder the ev's in decreasing order
  for(int r=1;r<=dim;r++) {
//    b=a-(q(r)*i);       // subtract off the eigenvalue
assign(a-(q(r)*i),b);       // subtract off the eigenvalue
    u=v=i;      // reset u and v to the identity
    svd(b,u,sv1,v,0.0);
      // The columns of u and v are now the left and right singular vectors
      // of b.  The last columns are the left and right eigenvectors.
    cout << "Deviation of eigenpair " << r << ": ";
    cout << sup(dot(a,v.col(dim),z) - q(r)*v.col(dim)) << '\n';
  }
  b=a;         // reset b
  z=p;         // reset z
  double_complex ev;
  cout << "Largest ev by power method: \n";
  eigen_power(b,ev,z,0.0);
  cout << "Deviation of largest eigenpair: ";
  cout << abs(ev-q(1)) << " , " << sup(dot(a-(ev*i),z,z)) << '\n';

  b=a;         // reset b
  z=p;         // reset z
  cout << "Smallest ev by inverse iteration: \n";
  ev=(double_complex)0.0;
  eigen_invit(b,ev,z,u,sv1,v,0.0);
  cout << "Deviation of smallest eigenpair: ";
  cout << abs(ev-q(dim)) << " , " << sup(dot(a-(ev*i),z,z)) << '\n';

  cout << "The accuracy of these routines is indicated by the size of the ";
  cout << "numbers reported above.\n";

  return 0;
}
