// Tests the transform class for least-squares polynomial fitting.

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This software is free; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
You should have received a copy of the GNU General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include<complex.h>
#include<mMatrix.h>
#include<instance.h>
#include<Viewport.h>
#include<transform.h>

int main(int argc,char **argv) {
  size_t size=atoi(argv[1]),one=1;
  mMatrix<double,allocator<double> > m(size,size);
  mVector<double,allocator<double> > q1(size);
  int j;

  for(j=1;j<=size;j++) q1(j)=sin((j-1)*2*M_PI/(q1.size()-1.0));
  Viewport vp;
  initPlot(vp,one,size,size,q1,0);              // plot function

  Monomial<double> mf;                          // expansion functions
  mf.a()=(double)1;                             // set endpoints of mesh
  mf.b()=(double)size;
  mf.resize(size,size);                         // set length of mesh
  Transform<double,double,Monomial<double> > tr(mf);  // transformation class

  // least-squares, cubic fit
  tr.resize(size,4);                            // set transform sizes
  tr.initMesh();                                // initialize mesh
  tr.initOp(0.0);                               // init operator matrices
  tr.data=q1;                                   // init transform data
  tr.forward();                                 // compute coefficients
  initPlot(vp,(double)1.0,(double)size,100,tr,1); // plot
  vp.pplot();

  // least-squares, order 7 polynomial fit
  tr.resize(size,8);                            // set transform sizes
  tr.initOp(0.0);                               // init operator matrices
  tr.forward();                                 // compute coefficients
  initPlot(vp,(double)1.0,(double)size,100,tr,1); // plot
  vp.pplot();
  return 0;
}
