// Exercises the plotting class Viewport

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This software is free; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
You should have received a copy of the GNU General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include<complex.h>
#include<mMatrix.h>
#include<instance.h>
#include<Viewport.h>

int main(int argc,char **argv) {
  size_t size=atoi(argv[1]),one=1;
  mMatrix<float,allocator<float> > m(size,size);
  mVector<float,allocator<float> > q1(size),q2(size),q3(size);
  mMatrix<float,allocator<float> > pp1(size,2),pp2(size,2),pp3(size,2);
  int j;

  Viewport vp;

  vp.title="2-dim frame plot of one vector, a sin function";
  for(j=1;j<=size;j++) q1(j)=sin((j-1)*2*M_PI/(q1.size()-1.0));
  initPlot(vp,one,size,size,q1,0);
  vp.pplot();

  vp.title="2-dim frame plot of cos and sin functions with dashing";
  vp.clearPlot(0);
  double (*cp)(double)=cos;
  double (*sp)(double)=sin;
  initPlot(vp,0.0,2*M_PI,size,cp,3);
  initPlot(vp,0.0,2*M_PI,size,sp,9);
  vp.pplot();
  vp.clearPlot();

  vp.title="2-dim frame plot of three lines";
  for(j=1;j<=size;j++) {
    q1(j)=j;
    q2(j)=2*j;
    q3(j)=3*j;
  }
  initPlot(vp,one,size,size,q1,0);
  initPlot(vp,one,size,size,q2,1);
  initPlot(vp,one,size,size,q3,2);
  vp.pplot();

  vp.title="2-dim parametric plot of three concentric circles";
  for(j=1;j<=size;j++) {
    pp1(j,1)=sin((j-1)*2*M_PI/(size-1.0));
    pp1(j,2)=cos((j-1)*2*M_PI/(size-1.0));
    pp2(j,1)=2*pp1(j,1);
    pp2(j,2)=2*pp1(j,2);
    pp3(j,1)=3*pp1(j,1);
    pp3(j,2)=3*pp1(j,2);
  }
  initParamPlot(vp,one,size,size,pp1.col(1),pp1.col(2),0);
  initParamPlot(vp,one,size,size,pp2.col(1),pp2.col(2),1);
  initParamPlot(vp,one,size,size,pp3.col(1),pp3.col(2),2);
  vp.pplot();

  for(j=1;j<=m.rsize();j++)     // init the matrix for 3-d plots
    for(int k=1;k<=m.csize();k++) m(j,k)=sin((j-1)*4*M_PI/(m.rsize()-1.0))*sin((k-1)*4*M_PI/(m.csize()-1.0));
  initSurfPlot(vp,one,m.rsize(),size,one,m.csize(),size,m);

  vp.title="2-dim contour plot of the matrix m, sin functions in x and y";
  vp.numContour=4;
  vp.rpix=300;
  vp.cpix=300;
  vp.cplot();

  vp.title="same as above, but with no contours";
  vp.frame=0;
  vp.numContour=0;
  vp.cplot();
  
  vp.title="same as above, with contours but no shading";
  vp.numContour=5;
  vp.autoContour=0;
  vp.contour(1)=-0.7;
  vp.contour(2)=-0.4;
  vp.contour(3)=0.0;
  vp.contour(4)=0.4;
  vp.contour(5)=0.7;
  vp.shading=0;
  vp.cplot();

  vp.title="3-dim frame plot of the matrix m, sin functions in x and y";
  vp.fplot();

  vp.title="Same with frame";
  vp.frame=1;
  vp.fplot();

  return 0;
}
