// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

bool VPBTrunk::idleHandler(TrunkEvent *event)
{
	char script[256];
	int argc = 0;
	const char *start = NULL;
	const char *data;
	const char *value;
	TrunkGroup *grp = NULL;
	char *sp;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		debug->DebugState(this, "idle");
		tgi.pid = 0;
		digits = 0;

		vpb_sethook_async(handle, VPB_ONHOOK);
		setDTMFDetect(false);
		flags.dsp = DSP_MODE_INACTIVE;
		flags.offhook = false;

		switch(flags.trunk)
		{
		case TRUNK_MODE_OUTGOING:
			group->decOutgoing();
			break;
		case TRUNK_MODE_INCOMING:
			group->decIncoming();
		}

		flags.trunk = TRUNK_MODE_INACTIVE;
		status[id] = '-';
		time(&idle);
		Purge();
		rings = 0;
		return true;
	case TRUNK_STOP_DISCONNECT:
	case TRUNK_LINE_WINK:
	case TRUNK_CPA_DIALTONE:
	case TRUNK_MAKE_IDLE:
		return true;
	case TRUNK_MAKE_BUSY:
		flags.trunk = TRUNK_MODE_UNAVAILABLE;
		handler = &VPBTrunk::busyHandler;
		return true;
	case TRUNK_START_SCRIPT:
		flags.trunk = TRUNK_MODE_OUTGOING;
	case TRUNK_RING_START:
		start = event->parm.argv[0];
		if(start)
		{
			if(strchr(start, '='))
				start = group->getSchedule(script);
			else
				++argc;
		}
		if(flags.trunk == TRUNK_MODE_INACTIVE)
			flags.trunk = TRUNK_MODE_INCOMING;
		rings = 0;
		if(!start)
			start = group->getSchedule(script);
		if(Attach(start))
		{
			while(event->parm.argv[argc])
			{
				strcpy(script, event->parm.argv[argc++]);
				data = strtok_r(script, "=", &sp);
				value = strtok_r(NULL, "=", &sp);
				if(data && value)
					setConstant(data, value);
			}		
			if(flags.trunk == TRUNK_MODE_OUTGOING)
			{
				handler = &VPBTrunk::seizeHandler;
				group->incOutgoing();
			}
			else
			{
				handler = &VPBTrunk::stepHandler;
				group->incIncoming();
			}
			return true;
		}
		flags.trunk = TRUNK_MODE_INACTIVE;
		slog(SLOG_ERROR) << "vpb" << id << ": " << start << ": cannot start" << endl;
		return true;		
	case TRUNK_RINGING_ON:
		rings = 1;
		flags.trunk = TRUNK_MODE_INCOMING;
		group->incIncoming();
		handler = &VPBTrunk::ringHandler;
		return true;
	}
	return false;
}
