// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

bool Resolver::instance = false;

Resolver::Resolver() :
Server(keythreads.priResolver())
{
	if(instance)
		throw(this);
	instance = true;
	interval = 60l * keythreads.getResolver();
}

void Resolver::Run(void)
{
	time_t last, now;
	long diff;
	Protocol *pro = Protocol::first;
	const char *addr;
	struct in_addr **bptr;
	struct hostent *hp;

	slog(SLOG_INFO) << "resolver: starting" << endl;

	time(&last);
	for(;;)
	{
		time(&now);
		diff = interval - (now - last);
		if(diff > 0)
			Sleep(diff * 1000);
		time(&last);
		slog(SLOG_DEBUG) << "resolver: updating" << endl;
		while(pro)
		{
			addr = pro->getLast("resolver");
			if(!addr)
			{
				pro = pro->next;
				continue;
			}
			hp = gethostbyname(addr);
			if(!hp)
			{
				pro = pro->next;
				continue;
			}
			bptr = (struct in_addr **)hp->h_addr_list;
			while(*bptr != NULL)
				++bptr;
			--bptr;
			pro->Update(InetHostAddress(**bptr));
			pro = pro->next;
		}		
	}
}

void Resolver::Stop(void)
{
	slog(SLOG_DEBUG) << "resolver: stopping" << endl;
	Terminate();
}

