// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

bool VPBTrunk::flashoffHandler(TrunkEvent *event)
{
	switch(event->id)
	{
	case TRUNK_CPA_DIALTONE:
		endTimer();
		if(TrunkSignal(TRUNK_SIGNAL_DIALTONE))
		{
			endTimer();
			handler = &VPBTrunk::stepHandler;
			return true;
		}
	case TRUNK_TIMER_EXPIRED:
		TrunkSignal(TRUNK_SIGNAL_STEP);
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_ENTER_STATE:
		debug->DebugState(this, "flashoff");
		flags.offhook = true;
		vpb_sethook_async(handle, VPB_OFFHOOK);
		if(data.flash.offhook < getPickupTimer())
			data.flash.offhook = getPickupTimer();
		setTimer(data.flash.offhook);
		return true;
	}
	return false;
}

bool VPBTrunk::flashonHandler(TrunkEvent *event)
{
	switch(event->id)
	{
	case TRUNK_TIMER_EXPIRED:
		handler = &VPBTrunk::flashoffHandler;
		return true;
	case TRUNK_ENTER_STATE:
		debug->DebugState(this, "flashon");
		setDTMFDetect(false);
		flags.dsp = DSP_MODE_VOICE;
		status[id] = 'f';
		if(!flags.offhook)
		{
			handler = &VPBTrunk::flashoffHandler;
			return true;
		}
		flags.offhook = false;
		vpb_sethook_async(handle, VPB_ONHOOK);
		setTimer(data.flash.onhook);
		return true;
	}
	return false;
}		
