// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

ZapataConfig::ZapataConfig() :
Keydata("/bayonne/zapata")
{
	static KEYDEF defkeys[] = {
	{NULL, NULL}};

	Load(defkeys);
}

ZapataDriver::ZapataDriver() :
Driver()
{
	ports = NULL;
	groups = NULL;
	port_count = 0;

	if(ports)
		memset(ports, 0, sizeof(ZapataTrunk *) * port_count);

	if(groups)
		memset(groups, 0, sizeof(TrunkGroup *) * port_count);

	slog(SLOG_INFO) << "Zapata driver loaded; capacity=" << port_count << endl;
}

ZapataDriver::~ZapataDriver()
{
	Stop();
	if(ports)
		delete ports;

	if(groups)
		delete groups;
}

int ZapataDriver::Start(void)
{
	int count = 0;

	if(active)
	{
		slog(SLOG_ERROR) << "driver already started" << endl;
		return 0;
	}

	slog(SLOG_INFO) << "driver starting..." << endl;

	active = true;
	return count;
}

void ZapataDriver::Stop(void)
{
	if(!active)
		return;

	if(ports)
		memset(ports, 0, sizeof(ZapataTrunk *) * port_count);

	active = false;
	slog(SLOG_INFO) << "driver stopping..." << endl;
}

Trunk *ZapataDriver::getTrunkPort(int id)
{
	if(id < 0 || id >= port_count)
		return NULL;

	if(!ports)
		return NULL;

	return (Trunk *)ports[id];
}

ZapataDriver zapataivr;
