// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonne.h"
#include <iomanip>

class TraceDebug : public Debug
{
public:
	TraceDebug();
	void DebugState(Trunk *trunk, char *state);
	void DebugScript(Trunk *trunk, char *msg);
	void DebugStep(Trunk *trunk, scriptline_t *line);
} trace;

TraceDebug::TraceDebug() :
Debug()
{
	slog(SLOG_INFO) << "debug: trace module loaded" << endl;
}

void TraceDebug::DebugScript(Trunk *trunk, char *msg)
{
	char buffer[32];
	char *value;

	EnterMutex();
	trunk->getName(buffer);
	slog(SLOG_DEBUG) << buffer << ": " << msg << endl;
	LeaveMutex();
}

void TraceDebug::DebugStep(Trunk *trunk, scriptline_t *line)
{
	int i;

	char buffer[32];
	trunk->getName(buffer);

	if(!line)
	{
		slog(SLOG_DEBUG) << buffer << ": exit" << endl;
		return;
	}

	EnterMutex();
	slog(SLOG_DEBUG) << buffer << ": step ";
	slog() << setbase(16) << line->mask << " " << setbase(10);
	slog() << line->cmd << "(";
	for(i = 0; i < line->argc; ++i)
	{
		if(i)
			slog() << ",";
		slog() << line->args[i];
	}
	slog() << ")" << endl;	
	LeaveMutex();
}

void TraceDebug::DebugState(Trunk *trunk, char *state)
{
	char buffer[32];
	trunk->getName(buffer);

	EnterMutex();
	slog(SLOG_DEBUG) << buffer << ": " << state << endl;
	LeaveMutex();
}

