// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "gui.h"

GUITabs::GUITabs(FXComposite *f) :
FXTabBook(f, NULL, 0, LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT)
{
	int item;

	mkitem(0, "&Info");
	new TabInfo(this);
	mkitem(1, "&Nodes");
	new FXHorizontalFrame(this, FRAME_THICK | FRAME_RAISED);
	mkitem(2, "&Groups");
	new FXHorizontalFrame(this, FRAME_THICK | FRAME_RAISED);
	mkitem(3, "&Lines");
	new FXHorizontalFrame(this, FRAME_THICK | FRAME_RAISED);
}


void GUITabs::mkitem(int id, FXchar *header)
{
	items[id] = new FXTabItem(this, header, NULL);
	items[id]->setFont(gui.getTitleFont());
}

