// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

unsigned Request::seq = 0;

Request::Request(TrunkGroup *grp, const char *text, unsigned seconds)
{
	int argc = 0;
	char *cp;
	char *tok;

	strcpy(buffer, text);
	cp = strtok_r(buffer, " \t\n\r", &tok);

	while(argc < 32 && cp)
	{
		argv[argc++] = cp;
		cp = strtok_r(NULL, " \t\n\r", &tok);
	}
	argv[argc] = NULL;

	time(&expires);
	expires += seconds;
	id = ++seq;
	slog(SLOG_DEBUG) << "request: " << group->getName() << "(" << id << ") posted";

	group = grp;
	group->EnterMutex();
	if(!group->reqfirst)
		group->reqfirst = this;
	if(group->reqlast)
		group->reqlast->next = this;
	group->reqlast = this;
	group->LeaveMutex();
}

void Request::Detach(void)
{
	if(!group)
		return;

	group->EnterMutex();
	if(this == group->reqfirst)
		group->reqfirst = next;
	if(this == group->reqlast)
		group->reqlast = next;
	group->reqlast = this;
	group->LeaveMutex();
	group = NULL;
}

bool Request::isExpired(void)
{
	time_t now;
	time(&now);

	if(now > expires)
		return true;
	return false;
}

















