// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonne.h"

Session *Session::first = NULL;
Session *Session::last = NULL;
Mutex Session::mutex;

Session::Session()
{
	mutex.EnterMutex();
	if(last)
		last->next = this;

	prev = last;
	next = NULL;

	last = this;
	if(!first)
		first = this;
	mutex.LeaveMutex();
}

void Session::Unlink(void)
{
	if(next == this)
		return;

	mutex.EnterMutex();
	if(prev)
		prev->next = next;
	else
		first = next;
	if(next)
		next->prev = prev;
	else
		last = prev;
	next = prev = this;
	mutex.LeaveMutex();
}

void Session::Clean(void)
{
	time_t now, expr;
	Session *base, *next;

	mutex.EnterMutex();
	base = first;
	time(&now);

	while(base)
	{
		next = base->next;
		expr = base->getExpires();
		if(expr && expr < now)
		{
			base->Unlink();
			delete base;
		}	
		base = next;
	}
	mutex.LeaveMutex();
}

Service::Service(Trunk *trk, int pri) :
Semaphore(), Thread((Semaphore *)this, pri, keythreads.getStack())
{
	trunk = trk;
	stopped = false;
	if(trunk->thread)
		trunk->stopServices();
	trunk->thread = this;
	data = &trunk->data;
	group = trunk->group;
}

void Service::Failure(void)
{
	TrunkEvent event;

	event.id = TRUNK_SERVICE_FAILURE;
	trunk->postEvent(&event);
	setCancel(THREAD_CANCEL_IMMEDIATE);
	Sleep(~0);
}

void Service::Success(void)
{
	TrunkEvent event;

	event.id = TRUNK_SERVICE_SUCCESS;
	trunk->postEvent(&event);
	setCancel(THREAD_CANCEL_IMMEDIATE);
	Sleep(~0);
}

char *Service::getPrompt(char *name)
{
	strstream str(filename, sizeof(filename));
	filename[0] = 0;
	char *cp;

	cp = strchr(name, '/');
	if(cp)
	{
		strcpy(filename, name);
		return filename;
	}

	str << keypaths.getLast("prompts");
	str << "/" << trunk->getSymbol("voice");
	str << "/" << name;
	cp = strchr(name, '.');
	if(!cp)
		str << trunk->getSymbol("extension");
	str << ends;
	return filename;
}

char *Service::getPlayfile(void)
{
	char buffer[128];
	char *cp = buffer;

	if(!trunk->data.play.name)
		return NULL;

	if(!*trunk->data.play.name)
		return NULL;

	while(*trunk->data.play.name && *trunk->data.play.name != ',')
		*(cp++) = *(trunk->data.play.name++);

	*cp = 0;
	while(*trunk->data.play.name && *trunk->data.play.name == ',')
		++trunk->data.play.name;

	return getPrompt(buffer);
}

timeout_t Service::Stop(void)
{
	stopped = true;
	return keythreads.getResetDelay();
}

