/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/


/*********************************************************************/
/*                                                                   */
/*  TOOLKIT: the "item file extension" object for cfengine           */
/*                                                                   */
/*********************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"

/*********************************************************************/

LoadItemList(liststart,file)

struct Item **liststart;
char *file;

{ FILE *fp;
  struct stat statbuf;
  int i;

if (stat(file,&statbuf) == -1)
   {
   printf("cfengine: Couldn't stat %s\n",file);
   return false;
   }

if ((EDITFILESIZE != 0) &&(statbuf.st_size > EDITFILESIZE))
   {
   printf("%s: File %s is bigger than the limit <editfilesize>\n",VPREFIX,file);
   return(false);
   }

if (! S_ISREG(statbuf.st_mode))
   {
   printf("%s: %s is not a plain file\n",VPREFIX,file);
   return false;
   }

if ((fp = fopen(file,"r")) == NULL)
   {
   printf("%s: Couldn't read file %s for editing\n",VPREFIX,file);
   return false;
   }


for (i = 0; i < bufsize; i++)
   {
   VBUFF[i] = 0;
   }

while(!feof(fp))
   {
   fgets (VBUFF,bufsize,fp);

   if(VBUFF[strlen(VBUFF)-1] == '\n')
      {
      VBUFF[strlen(VBUFF)-1] = '\0';        /* chop */
      }

   if (!feof(fp) || strlen(VBUFF) != 0) 
      {
      AppendItem(liststart,VBUFF,NULL);
      }

   VBUFF[0] = '\0';
   }

fclose(fp);
return (true);
}

/*********************************************************************/

SaveItemList(liststart,file)

struct Item *liststart;
char *file;

{ struct Item *ip;
  struct stat statbuf;
  FILE *fp;

if (stat(file,&statbuf) == -1)
   {
   printf("%s: Couldn't stat %s, which needed editing!\n",VPREFIX,file);
   printf("%s: Check definition in program - is file NFS mounted?\n\n",VPREFIX);
   return false;
   }

strcpy(VBUFF,file);
strcat(VBUFF,CF_EDITED);

if (! IsItemIn(VREPOSLIST,VBUFF))
   {
   if (rename(file,VBUFF) == -1)
      {
      printf("cfengine: Error occurred while renaming %s\n",file);
      perror("rename ");
      return false;
      }
   else if (Repository(VBUFF))
      {
      unlink(VBUFF);
      }
   }

if ((fp = fopen(file,"w")) == NULL)
   {
   printf("%s: Couldn't write file %s after editing\n",VPREFIX,file);
   rename(VBUFF,file);
   return false;
   }

for (ip = liststart; ip != NULL; ip=ip->next)
   {
   fprintf(fp,"%s\n",ip->name);
   }

printf("%s: Edited file %s \n",VPREFIX,file);

fclose(fp);
chmod(file,statbuf.st_mode);                    /* Restore file permissions etc */
chown(file,statbuf.st_uid,statbuf.st_gid);
return true;
}
