/* Copyright (C) 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.

  However Display Ghostscript System depends on GLib. */

/* $Id: dgsconn.h,v 1.2 2000/02/28 19:31:31 cigas Exp $ */

#ifndef dgsconn_INCLUDED
#define dgsconn_INCLUDED

#include "dgs.h"

/* CONNection setting up functions */
void conn_sock_initialize(void);
void conn_sock_finalize(void *sockaddr, enum conn_type type);

int conn_server_create(void *sockaddr, enum conn_type type);
int conn_server_bind(int server_socket,
		     void *sockaddr, int base_port, enum conn_type type);
void conn_server_close(int server_socket);
int conn_base_port_find(void);
int conn_hostname_get(char *hostname, enum conn_type type);

int conn_atom_setup(Display * shared_dpy,
		    Window win_unix, int port_unix,
		    Window win_tcp, int port_tcp);
void conn_atom_cleanup(void);
int conn_insock_accept(int server_socket, enum conn_type type);
void conn_insock_close(int insock);

/* buf */

/* Use this to hide gs streams in call to buf_input_forward */
typedef struct DGS_stream_cursor_write_s {
    unsigned char *ptr;
    unsigned char *limit;
} DGS_stream_cursor_write;

gsdpsx_conn_buf *buf_init(void);
int buf_recv(gsdpsx_conn_buf * buf, gsdpsx_conn_info * conn);
void buf_finalize(gsdpsx_conn_buf * buf);
void buf_reset(gsdpsx_conn_buf * buf);
void buf_input_forward(gsdpsx_conn_buf * buf, DGS_stream_cursor_write * pw);
void buf_input_set(gsdpsx_conn_buf * buf, unsigned char *start, int length);
void buf_move_cursor(gsdpsx_conn_buf * buf, unsigned char *cur, int len);
void buf_pack(gsdpsx_conn_buf * buf, unsigned char *cur, int len);

#endif /* dgsconn_INCLUDED */
