/* Copyright (C) 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.

  However Display Ghostscript System depends on GLib. */

/* $Id: dgsmisc.c,v 1.2 2000/02/28 19:31:31 cigas Exp $ */
/* Display Ghostscript support functions */

#include <glib.h>		/* For Hash tables */
#include "stdio_.h"

/* the X people can't make their headers define what they need automatically... */
#define NEED_REPLIES
#define NEED_EVENTS
#include "x_.h"			/* standard X include files */
#include "DPSCAPproto.h"
#include "DPS/XDPS.h"

#include <unistd.h>
#include <signal.h>

#include "dgsmisc.h"

/* --- debug facilities --- */

/* For protocol debugging */
const private char *util_x_ps_request_table[] = {
    "WrongPSRequest",
    "X_PSInit",			/* 1 */
    "X_PSCreateContext",	/* 2, Has stub */
    "X_PSCreateSpace",		/* 3 */
    "X_PSGiveInput",		/* 4, Has stub */
    "X_PSGetStatus",		/* 5 */
    "X_PSDestroySpace",		/* 6, Has stub */
    "X_PSReset",		/* 7 */
    "X_PSNotifyContext",	/* 8, Has stub */
    "X_PSCreateContextFromID",	/* 9 */
    "X_PSXIDFromContext",	/* 10 */
    "X_PSContextFromXID",	/* 11 */
    "X_PSSetStatusMask",	/* 12,  Has stub */
    "X_PSCreateSecureContext",	/* 13, L2-DPS/PROTO 9 addition */
    "X_PSNotifyWhenReady",	/* 14, L2-DPS/PROTO 9 addition */
};

const char *
util_x_ps_request_enum2str(int key)
{
    if ((1 > key) && (key > PSLASTREQUEST))
	key = 0;
    return util_x_ps_request_table[key];
}

const private char *util_x_cap_request_table[] = {
    "WrongCAPRequest",
    "X_CAPFlushAgent",		/* 1 */
    "X_CAPNotify",		/* 2 */
    "X_CAPSetArg",		/* 3 */
};

const char *
util_x_cap_request_enum2str(int key)
{
    if ((1 > key) && (key > X_CAPSetArg))
	key = 0;
    return util_x_cap_request_table[key];
}

const char *
util_conn_type_enum2str(enum conn_type type)
{
    if (type == UNIXCONN)
	return "UNIXCONN";
    else if (type == TCPCONN)
	return "TCPCONN";
    else
	return "UNKNOWN CONN";
}

const char *
util_status_enum2str(int key)
{
    switch (key) {
	case PSSTATUSERROR:
	    return "PSSTATUSERROR";
	case PSRUNNING:
	    return "PSRUNNING";
	case PSNEEDSINPUT:
	    return "PSNEEDSINPUT";
	case PSZOMBIE:
	    return "PSZOMBIE";
	case PSFROZEN:
	    return "PSFROZEN";
	default:
	    return "Unknown status";
    }
}

const char *
util_signal_int2str(int sig)
{
    switch (sig) {
	case 0:
	    return "EOF";
	case SIGHUP:
	    return "SIGHUP";
	case SIGTERM:
	    return "SIGTERM";
	case SIGINT:
	    return "SIGINT";
	case SIGCHLD:
	    return "SIGCHLD";
	case SIGSEGV:
	    return "SIGSEGV";
	default:
	    return "Unknown";
    }
}

void
debug_print_pid(int sec)
{
    int i;

    if (sec < 2)
	return;

    fprintf(stderr, "attach %d\n", getpid());
    for (i = 0; i < sec; i++) {
	sleep(1);
	fprintf(stderr, ".");
    }
    fprintf(stderr, "\n");
}

/* Return 1 if the htons or htonl invocation is needed. */
int
util_byteorder_check(gsdpsx_conn_info * conn)
{
    if ((shared_byteorder == 'l') && (conn->byteorder == 'B'))
	return 1;
    else
	return 0;
}

/* --- GSet --- */
GSet *
g_set_add(GSet * set, gpointer data)
{
    return g_slist_append(set, data);
}
GSet *
g_set_remove(GSet * set, gpointer data)
{
    return g_slist_remove(set, data);
}
gpointer g_set_member(GSet * set, gpointer data)
{
    return g_slist_find(set, data);
}
void
g_set_foreach(GSet * set, GFunc func, gpointer user_data)
{
    g_slist_foreach(set, func, user_data);
}
guint g_set_count(GSet * set)
{
    return g_slist_length(set);
}
