/*
 * opdef.c - Opcode definition tables.
 *
 * Copyright (C) 2001, 2002  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef IL_MAIN_OPDEF

OPDEF("nop",				0, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("break",				0, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("ldarg.0",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldarg.1",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldarg.2",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldarg.3",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldloc.0",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldloc.1",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldloc.2",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldloc.3",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stloc.0",			1, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stloc.1",			1, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stloc.2",			1, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stloc.3",			1, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("ldarg.s",			0, 1, IL_OPCODE_ARGS_SHORT_ARG, 2)
OPDEF("ldarga.s",			0, 1, IL_OPCODE_ARGS_SHORT_ARG, 2)
OPDEF("starg.s",			1, 0, IL_OPCODE_ARGS_SHORT_ARG, 2)
OPDEF("ldloc.s",			0, 1, IL_OPCODE_ARGS_SHORT_VAR, 2)
OPDEF("ldloca.s",			0, 1, IL_OPCODE_ARGS_SHORT_VAR, 2)
OPDEF("stloc.s",			1, 0, IL_OPCODE_ARGS_SHORT_VAR, 2)

OPDEF("ldnull",				0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.m1",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.0",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.1",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.2",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.3",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.4",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.5",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.6",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.7",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.8",			0, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldc.i4.s",			0, 1, IL_OPCODE_ARGS_INT8, 2)
OPDEF("ldc.i4",				0, 1, IL_OPCODE_ARGS_INT32, 5)
OPDEF("ldc.i8",				0, 1, IL_OPCODE_ARGS_INT64, 9)
OPDEF("ldc.r4",				0, 1, IL_OPCODE_ARGS_FLOAT32, 5)
OPDEF("ldc.r8",				0, 1, IL_OPCODE_ARGS_FLOAT64, 9)

OPDEF("ldptr",				0, 1, IL_OPCODE_ARGS_INT32, 5)

OPDEF("dup",				1, 2, IL_OPCODE_ARGS_NONE, 1)
OPDEF("pop",				1, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("jmp",				0, 0, IL_OPCODE_ARGS_CALL, 5)
OPDEF("call",				0, 0, IL_OPCODE_ARGS_CALL, 5)
OPDEF("calli",				0, 0, IL_OPCODE_ARGS_CALLI, 5)
OPDEF("ret",				0, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("br.s",				0, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("brfalse.s",			1, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("brtrue.s",			1, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("beq.s",				2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("bge.s",				2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("bgt.s",				2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("ble.s",				2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("blt.s",				2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("bne.un.s",			2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("bge.un.s",			2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("bgt.un.s",			2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("ble.un.s",			2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("blt.un.s",			2, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)
OPDEF("br",					0, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("brfalse",			1, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("brtrue",				1, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("beq",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("bge",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("bgt",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("ble",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("blt",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("bne.un",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("bge.un",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("bgt.un",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("ble.un",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("blt.un",				2, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)

OPDEF("switch",				1, 0, IL_OPCODE_ARGS_SWITCH, 0)

OPDEF("ldind.i1",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.u1",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.i2",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.u2",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.i4",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.u4",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.i8",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.i",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.r4",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.r8",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldind.ref",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stind.ref",			2, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stind.i1",			2, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stind.i2",			2, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stind.i4",			2, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stind.i8",			2, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stind.r4",			2, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stind.r8",			2, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("add",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("sub",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("mul",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("div",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("div.un",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("rem",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("rem.un",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("and",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("or",					2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("xor",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("shl",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("shr",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("shr.un",				2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("neg",				1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("not",				1, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("conv.i1",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.i2",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.i4",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.i8",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.r4",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.r8",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.u4",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.u8",			1, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("callvirt",			0, 0, IL_OPCODE_ARGS_CALLVIRT, 5)
OPDEF("cpobj",				2, 0, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ldobj",				1, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ldstr",				0, 1, IL_OPCODE_ARGS_STRING, 5)

OPDEF("newobj",				0, 0, IL_OPCODE_ARGS_NEW, 5)
OPDEF("castclass",			1, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("isinst",				1, 1, IL_OPCODE_ARGS_TOKEN, 5)

OPDEF("conv.r.un",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ann.data.s",			0, 0, IL_OPCODE_ARGS_ANN_DATA, 0)

OPDEF("unused_78",			0, 0, IL_OPCODE_ARGS_INVALID, 1)

OPDEF("unbox",				1, 1, IL_OPCODE_ARGS_TOKEN, 5)

OPDEF("throw",				1, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("ldfld",				1, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ldflda",				1, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("stfld",				2, 0, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ldsfld",				0, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ldsflda",			0, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("stsfld",				1, 0, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("stobj",				2, 0, IL_OPCODE_ARGS_TOKEN, 5)

OPDEF("conv.ovf.i1.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i2.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i4.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i8.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u1.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u2.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u4.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u8.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u.un",		1, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("box",				1, 1, IL_OPCODE_ARGS_TOKEN, 5)

OPDEF("newarr",				1, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ldlen",				1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelema",			2, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ldelem.i1",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.u1",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.i2",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.u2",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.i4",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.u4",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.i8",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.i",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.r4",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.r8",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ldelem.ref",			2, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("stelem.i",			3, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stelem.i1",			3, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stelem.i2",			3, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stelem.i4",			3, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stelem.i8",			3, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stelem.r4",			3, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stelem.r8",			3, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("stelem.ref",			3, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("ldelem",				2, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("stelem",				3, 0, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("unbox.any",			1, 1, IL_OPCODE_ARGS_TOKEN, 5)

OPDEF("unused_A6",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_A7",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_A8",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_A9",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_AA",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_AB",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_AC",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_AD",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_AE",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_AF",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_B0",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_B1",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_B2",			0, 0, IL_OPCODE_ARGS_INVALID, 1)

OPDEF("conv.ovf.i1",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u1",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i2",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u2",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i4",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u4",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i8",		1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u8",		1, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("unused_BB",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_BC",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_BD",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_BE",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_BF",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_C0",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_C1",			0, 0, IL_OPCODE_ARGS_INVALID, 1)

OPDEF("refanyval",			1, 1, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ckfinite",			1, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("unused_C4",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_C5",			0, 0, IL_OPCODE_ARGS_INVALID, 1)

OPDEF("mkrefany",			1, 1, IL_OPCODE_ARGS_TOKEN, 5)

OPDEF("ann.call",			0, 0, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ann.catch",			0, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ann.dead",			0, 0, IL_OPCODE_ARGS_ANN_DEAD, 3)
OPDEF("ann.hoisted",		0, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ann.hoisted_call",	0, 0, IL_OPCODE_ARGS_TOKEN, 5)
OPDEF("ann.lab",			0, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ann.def",			0, 0, IL_OPCODE_ARGS_NONE, 1)
OPDEF("ann.ref.s",			0, 0, IL_OPCODE_ARGS_ANN_REF, 2)
OPDEF("ann.phi",			0, 0, IL_OPCODE_ARGS_ANN_PHI, 0)

OPDEF("ldtoken",			0, 1, IL_OPCODE_ARGS_LDTOKEN, 5)

OPDEF("conv.u2",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.u1",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.i",				1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.i",			1, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("conv.ovf.u",			1, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("add.ovf",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("add.ovf.un",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("mul.ovf",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("mul.ovf.un",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("sub.ovf",			2, 1, IL_OPCODE_ARGS_NONE, 1)
OPDEF("sub.ovf.un",			2, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("endfinally",			0, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("leave",				0, 0, IL_OPCODE_ARGS_LONG_JUMP, 5)
OPDEF("leave.s",			0, 0, IL_OPCODE_ARGS_SHORT_JUMP, 2)

OPDEF("stind.i",			2, 0, IL_OPCODE_ARGS_NONE, 1)

OPDEF("conv.u",				1, 1, IL_OPCODE_ARGS_NONE, 1)

OPDEF("unused_E1",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E2",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E3",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E4",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E5",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E6",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E7",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E8",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_E9",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_EA",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_EB",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_EC",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_ED",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_EE",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_EF",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F0",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F1",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F2",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F3",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F4",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F5",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F6",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F7",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F8",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_F9",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_FA",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_FB",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_FC",			0, 0, IL_OPCODE_ARGS_INVALID, 1)
OPDEF("unused_FD",			0, 0, IL_OPCODE_ARGS_INVALID, 1)

OPDEF("prefix",				0, 0, IL_OPCODE_ARGS_INVALID, 0)

OPDEF("unused_FF",			0, 0, IL_OPCODE_ARGS_INVALID, 1)

#endif /* IL_MAIN_OPDEF */

#ifdef IL_PREFIX_OPDEF

OPDEF("arglist",			0, 1, IL_OPCODE_ARGS_NONE, 2)

OPDEF("ceq",				2, 1, IL_OPCODE_ARGS_NONE, 2)
OPDEF("cgt",				2, 1, IL_OPCODE_ARGS_NONE, 2)
OPDEF("cgt.un",				2, 1, IL_OPCODE_ARGS_NONE, 2)
OPDEF("clt",				2, 1, IL_OPCODE_ARGS_NONE, 2)
OPDEF("clt.un",				2, 1, IL_OPCODE_ARGS_NONE, 2)

OPDEF("ldftn",				0, 1, IL_OPCODE_ARGS_TOKEN, 6)
OPDEF("ldvirtftn",			1, 1, IL_OPCODE_ARGS_TOKEN, 6)

OPDEF("jmpi",				1, 0, IL_OPCODE_ARGS_CALLI, 6)

OPDEF("ldarg",				0, 1, IL_OPCODE_ARGS_LONG_VAR, 4)
OPDEF("ldarga",				0, 1, IL_OPCODE_ARGS_LONG_VAR, 4)
OPDEF("starg",				1, 0, IL_OPCODE_ARGS_LONG_VAR, 4)
OPDEF("ldloc",				0, 1, IL_OPCODE_ARGS_LONG_VAR, 4)
OPDEF("ldloca",				0, 1, IL_OPCODE_ARGS_LONG_VAR, 4)
OPDEF("stloc",				1, 0, IL_OPCODE_ARGS_LONG_VAR, 4)

OPDEF("localloc",			1, 1, IL_OPCODE_ARGS_NONE, 2)

OPDEF("unused_prefix_10",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("endfilter",			1, 0, IL_OPCODE_ARGS_NONE, 2)
OPDEF("unaligned.",			0, 0, IL_OPCODE_ARGS_UINT8, 3)
OPDEF("volatile.",			0, 0, IL_OPCODE_ARGS_NONE, 2)
OPDEF("tail.",				0, 0, IL_OPCODE_ARGS_NONE, 2)
OPDEF("initobj",			1, 0, IL_OPCODE_ARGS_TOKEN, 6)
OPDEF("constrained.",		0, 0, IL_OPCODE_ARGS_TOKEN, 6)
OPDEF("cpblk",				3, 0, IL_OPCODE_ARGS_NONE, 2)
OPDEF("initblk",			3, 0, IL_OPCODE_ARGS_NONE, 2)
OPDEF("no.",				0, 0, IL_OPCODE_ARGS_UINT8, 3)
OPDEF("rethrow",			0, 0, IL_OPCODE_ARGS_NONE, 2)

OPDEF("unused_prefix_1B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("sizeof",				0, 1, IL_OPCODE_ARGS_TOKEN, 6)
OPDEF("refanytype",			1, 1, IL_OPCODE_ARGS_NONE, 2)
OPDEF("readonly.",			0, 0, IL_OPCODE_ARGS_NONE, 2)

OPDEF("unused_prefix_1F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_20",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_21",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("ann.data",			0, 0, IL_OPCODE_ARGS_ANN_DATA, 0)
OPDEF("ann.arg",			0, 0, IL_OPCODE_ARGS_ANN_ARG, 4)

OPDEF("unused_prefix_24",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_25",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_26",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_27",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_28",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_29",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_2A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_2B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_2C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_2D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_2E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_2F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_30",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_31",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_32",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_33",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_34",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_35",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_36",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_37",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_38",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_39",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_3A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_3B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_3C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_3D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_3E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_3F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_40",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_41",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_42",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_43",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_44",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_45",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_46",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_47",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_48",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_49",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_4A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_4B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_4C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_4D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_4E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_4F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_50",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_51",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_52",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_53",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_54",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_55",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_56",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_57",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_58",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_59",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_5A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_5B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_5C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_5D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_5E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_5F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_60",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_61",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_62",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_63",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_64",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_65",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_66",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_67",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_68",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_69",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_6A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_6B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_6C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_6D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_6E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_6F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_70",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_71",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_72",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_73",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_74",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_75",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_76",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_77",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_78",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_79",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_7A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_7B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_7C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_7D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_7E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_7F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_80",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_81",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_82",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_83",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_84",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_85",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_86",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_87",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_88",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_89",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_8A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_8B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_8C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_8D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_8E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_8F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_90",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_91",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_92",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_93",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_94",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_95",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_96",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_97",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_98",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_99",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_9A",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_9B",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_9C",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_9D",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_9E",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_9F",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_A0",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A1",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A2",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A3",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A4",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A5",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A6",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A7",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A8",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_A9",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_AA",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_AB",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_AC",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_AD",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_AE",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_AF",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_B0",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B1",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B2",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B3",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B4",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B5",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B6",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B7",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B8",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_B9",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_BA",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_BB",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_BC",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_BD",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_BE",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_BF",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_C0",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C1",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C2",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C3",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C4",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C5",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C6",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C7",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C8",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_C9",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_CA",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_CB",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_CC",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_CD",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_CE",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_CF",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_D0",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D1",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D2",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D3",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D4",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D5",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D6",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D7",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D8",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_D9",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_DA",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_DB",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_DC",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_DD",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_DE",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_DF",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_E0",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E1",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E2",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E3",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E4",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E5",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E6",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E7",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E8",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_E9",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_EA",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_EB",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_EC",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_ED",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_EE",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_EF",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

OPDEF("unused_prefix_F0",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F1",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F2",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F3",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F4",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F5",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F6",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F7",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F8",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_F9",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_FA",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_FB",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_FC",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_FD",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_FE",	0, 0, IL_OPCODE_ARGS_INVALID, 2)
OPDEF("unused_prefix_FF",	0, 0, IL_OPCODE_ARGS_INVALID, 2)

#endif /* IL_PREFIX_OPDEF */
