/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gnu.gleem.CameraParameters;
import gnu.gleem.ScreenToRayMapping;
import gnu.gleem.linalg.Vec2f;
import gnu.gleem.linalg.Vec3f;

public class RightTruncPyrMapping
implements ScreenToRayMapping {
    public void mapScreenToRay(Vec2f screenCoords, CameraParameters params, Vec3f raySource, Vec3f rayDirection) {
        Vec3f fwd = new Vec3f(params.getForwardDirection());
        Vec3f up = new Vec3f(params.getUpDirection());
        Vec3f right = fwd.cross(up);
        fwd.normalize();
        up.normalize();
        right.normalize();
        float horizFOV = (float)Math.atan((double)params.imagePlaneAspectRatio * Math.tan(params.vertFOV));
        right.scale((float)(Math.tan(horizFOV) * (double)screenCoords.get(0)));
        up.scale((float)(Math.tan(params.vertFOV) * (double)screenCoords.get(1)));
        raySource.set(params.getPosition());
        rayDirection.set(fwd.plus(up).plus(right));
    }
}

