/* glpapi/glp_set_activity.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_set_activity - set activity of the current row or column.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_set_activity(int what, int tagx, double valx, double dx);
--
-- *Description*
--
-- If what = GLP_ROW, the glp_set_activity routine assigns the computed
-- solution to the current row.
--
-- If what = GLP_COL, the glp_set_activity routine assigns the computed
-- solution to the current column.
--
-- The parameter tagx specifies the status of row/column:
--
-- GLP_BS - the variable is basis;
-- GLP_NL - the variable is non-basis and placed on its lower bound
--          (only for variables of GLP_LO and GLP_DB types);
-- GLP_NU - the variable is non-basis and placed on its upper bound
--          (only for variables of GLP_UP and GLP_DB types);
-- GLP_NF - the free variable is non-basis (only for variables of
--          GLP_FR type);
-- GLP_NS - the fixed variable is non-basis (only for variables of
--          GLP_FX type).
--
-- The parameter valx specifies the primal activity (the computed value
-- of the variable).
--
-- The parameter dx specifies the dual activity (the computed marginal
-- value of the variable).
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the current row/column is undefined;
-- 2 - the parameter what is invalid, or the parameter tagx specifies
--     invalid status. */

int glp_set_activity(int what, int tagx, double valx, double dx)
{     GLPITEM *item;
      if (what == GLP_ROW)
         item = glp->this_row;
      else if (what == GLP_COL)
         item = glp->this_col;
      else
      {  /* invalid parameter */
         return 2;
      }
      if (item == NULL) return 1;
      if (!(tagx == GLP_BS || tagx == GLP_NL || tagx == GLP_NU ||
            tagx == GLP_NF || tagx == GLP_NS)) return 2;
      item->tagx = tagx;
      item->valx = valx;
      item->dx = dx;
      return 0;
}

/* eof */
