/* glpset/create_pool.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_pool - create memory pool.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- POOL *create_pool(int size);
--
-- *Description*
--
-- The create_pool routine creates a memory pool that is empty (i.e.
-- that contains no atoms). If size > 0 then size of each atom is set
-- to size bytes (size should be not greater than 256). Otherwise, if
-- size = 0 then different atoms may have different sizes.
--
-- *Returns*
--
-- The create_pool routine returns a pointer to the created pool. */

POOL *create_pool(int size)
{     POOL *pool;
      if (!(0 <= size && size <= 256))
         fault("create_pool: invalid atom size");
      pool = umalloc(sizeof(POOL));
      /* actual atom size should be not less than sizeof(void *) and
         should be properly aligned */
      if (size > 0)
      {  if (size < sizeof(void *)) size = sizeof(void *);
         size = align_datasize(size);
      }
      pool->size = size;
      pool->avail = NULL;
      pool->link = NULL;
      pool->used = 0;
      pool->stock = NULL;
      pool->count = 0;
      return pool;
}

/* eof */
