/* glpset/ufree.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stdlib.h>
#include "glpset.h"

/*----------------------------------------------------------------------
-- ufree - free memory block.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- void ufree(void *ptr);
--
-- *Description*
--
-- The ufree routine frees the memory block pointed to by ptr and which
-- was previuosly allocated by the umalloc or ucalloc routine. */

void ufree(void *ptr)
{     struct mem_desc *desc;
      int size_of_desc = align_datasize(sizeof(struct mem_desc));
      if (ptr == NULL)
         fault("ufree: null pointer");
      desc = (void *)((char *)ptr - size_of_desc);
      if (desc->flag != mem_flag)
         fault("ufree: invalid pointer");
      if (mem_total < desc->size || mem_count == 0)
         fault("ufree: memory allocation error");
      mem_total -= desc->size;
      mem_count--;
      desc->flag = 0;
      free(desc);
      return;
}

/* eof */
