/* glpapi/glp_get_cpar.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <string.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_cpar - get value of text control parameter.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_cpar(char *name, char *val);
--
-- *Description*
--
-- The glp_get_cpar routine copies the value of the text control
-- parameter with the given name to the character string val.
--
-- See the documentation for descriptions of all control parameters.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the given name is invalid. */

int glp_get_cpar(char *name, char *val)
{     if (strcmp(name, "fn_gener") == 0)
      {  /* file name to output generated LP/MIP problem */
         if (glp->fn_gener == NULL)
            val[0] = '\0';
         else
            get_str(val, glp->fn_gener);
      }
      else if (strcmp(name, "mps_bnd_name") == 0)
      {  /* the name of bound vector */
         strcpy(val, glp->mps_bnd_name);
      }
      else if (strcmp(name, "mps_obj_name") == 0)
      {  /* the name of the objective function */
         strcpy(val, glp->mps_obj_name);
      }
      else if (strcmp(name, "mps_rhs_name") == 0)
      {  /* the name of the right-hand side (RHS) vector */
         strcpy(val, glp->mps_rhs_name);
      }
      else if (strcmp(name, "mps_rng_name") == 0)
      {  /* the name of the range vector */
         strcpy(val, glp->mps_rng_name);
      }
      else if (strcmp(name, "obj_row") == 0)
      {  /* the name of the objective function */
         if (glp->obj_row == NULL)
            val[0] = '\0';
         else
            get_str(val, glp->obj_row->name);
      }
      else if (strcmp(name, "problem") == 0)
      {  /* the name of problem */
         get_str(val, glp->problem);
      }
      else
      {  /* invalid parameter name */
         return 1;
      }
      return 0;
}

/* eof */
