/* glpapi/glp_terminate.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_terminate - terminate GLPK application program interface.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_terminate(void);
--
-- *Description*
--
-- The glp_terminate routine terminates the GLPK application program
-- interface (API) and frees all memory allocated to the workspace. All
-- data in the workspace are destroyed.
--
-- As a rule this routine is used before termination of the application
-- program. However, it may be used also for cleaning the workspace --
-- in this case the application program should call the glp_initialize
-- routine again for re-initializing API.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - GLPK API already terminated. */

int glp_terminate(void)
{     if (glp == NULL) return 1;
      delete_pool(glp->str_pool);
      delete_pool(glp->item_pool);
      delete_pool(glp->coef_pool);
      delete_avl(glp->row_tab);
      delete_avl(glp->col_tab);
      ufree(glp);
      glp = NULL;
      return 0;
}

/* eof */
