/* glprsm/eval_xn.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glprsm.h"

/*----------------------------------------------------------------------
-- eval_xn - determine value of non-basic variable.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- double eval_xn(RSM *rsm, int j);
--
-- *Returns*
--
-- The eval_xn routine returns the value of non-basic variable xN[j],
-- 1 <= j <= n, that corresponds to the current basis solution. */

double eval_xn(RSM *rsm, int j)
{     int n = rsm->n, k;
      double t;
      insist(1 <= j && j <= n);
      k = rsm->indn[j]; /* x[k] = xN[j] */
      switch (rsm->tagn[j])
      {  case 'L':
            /* xN[j] on its lower bound */
            t = rsm->lb[k];
            break;
         case 'U':
            /* xN[j] on its upper bound */
            t = rsm->ub[k];
            break;
         case 'F':
            /* xN[j] is free variable */
            t = 0.0;
            break;
         case 'S':
            /* xN[j] is fixed variable */
            t = rsm->lb[k];
            break;
         default:
            insist(rsm->tagn[j] != rsm->tagn[j]);
      }
      return t;
}

/* eof */
