/* glprsm/update_b.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- update_b - update representation of basis matrix.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- int update_b(RSM *rsm, int p);
--
-- *Description*
--
-- Let p-th column of the current basis matrix B has been replaced by
-- some other column that gives the new (adjacent) basis matrix Bnew.
-- The update_b routine updates some representation of the basis matrix
-- B in order that the updated representation corresponds to the matrix
-- Bnew.
--
-- The new p-th column of the basis matrix is passed implcitly to this
-- routine. It is assmued that this column was saved before by means of
-- the ftran routine.
--
-- *Returns*
--
-- The update_b routine returns one of the following codes:
--
-- 0 - the representation has been successfully updated;
-- 1 - the representation has become inaccurate;
-- 2 - the representation has become too long.
--
-- If the returned code is non-zero, the calling program should rebuild
-- the representation anew by means of the invert_b routine. */

int update_b(RSM *rsm, int p)
{     int ret;
      if (rsm->efi != NULL)
         ret = update_efi(rsm->efi, p);
      else if (rsm->rfi != NULL)
         ret = update_rfi(rsm->rfi, p);
      else
         insist(rsm != rsm);
      return ret;
}

/* eof */
