/* glpapi/glp_get_row_coef.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_row_coef - get row of constraint matrix.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_row_coef(LPI *lp, int i, int cn[], double ai[]);
--
-- *Description*
--
-- The routine glp_get_row_coef scans elements of the i-th row of the
-- constraint matrix and stores their column indices and values to
-- locations cn[1], ..., cn[nz'] and ai[1], ..., ai[nz'] respectively,
-- where 0 <= nz' <= n is number of elements in the i-th row, n is
-- number of columns.
--
-- *Returns*
--
-- The routine returns nz', which is the number of stored elements. */

int glp_get_row_coef(LPI *lp, int i, int cn[], double ai[])
{     ELEM *e;
      int nz = 0;
      if (!(1 <= i && i <= lp->m))
         fault("glp_get_row_coef: i = %d; invalid row number", i);
      for (e = lp->row[i]->ptr; e != NULL; e = e->row)
      {  nz++;
         if (nz > lp->n)
            fault("glp_get_row_coef: i = %d; multiplets detected", i);
         cn[nz] = e->j;
         ai[nz] = e->val;
      }
      return nz;
}

/* eof */
