/* glpapi/glp_get_status.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_status - determine solution status.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_status(LPI *lp);
--
-- *Returns*
--
-- The routine glp_get_status returns one of the following codes that
-- shows current status of the problem solution:
--
-- GLP_UNDEF   - solution is undefined;
-- GLP_OPT     - solution is optimal;
-- GLP_FEAS    - solution is feasible;
-- GLP_INFEAS  - solution is infeasible;
-- GLP_NOFEAS  - problem has no feasible solution;
-- GLP_UNBND   - problem has unbounded solution;
-- GLP_INTOPT  - solution is integer optimal;
-- GLP_INTSOL  - solution is integer feasible;
-- GLP_DISINT  - solution is integer infeasible;
-- GLP_NOINT   - problem has no integer solution. */

int glp_get_status(LPI *lp)
{     return lp->status;
}

/* eof */
