/* glpapi/glp_set_col_fctr.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_set_col_fctr - set column scale factor.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- void glp_set_col_fctr(LPI *lp, int j, double fctr);
--
-- *Description*
--
-- The routine glp_set_col_fctr sets (changes) scale factor of the j-th
-- column specified by the parameter fctr (should be positive).
--
-- Column scale factor is an optional quantity, which may be used by the
-- solver in order to scale the problem. */

void glp_set_col_fctr(LPI *lp, int j, double fctr)
{     if (!(1 <= j && j <= lp->n))
         fault("glp_set_col_fctr: j = %d; invalid column number", j);
      if (fctr <= 0.0)
         fault("glp_set_col_fctr: fctr = %g; invalid scale factor",
            fctr);
      lp->col[j]->fctr = fctr;
      return;
}

/* eof */
