/* glpefi/create_efi.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpefi.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_efi - create EFI.
--
-- *Synopsis*
--
-- #include "glpefi.h"
-- EFI *create_efi(int m);
--
-- *Description*
--
-- The create_efi routine creates EFI for the basis matrix of order m.
-- Initially the created EFI corresponds to the unity matrix.
--
-- *Returns*
--
-- The create_efi routine returns a pointer to the created EFI. */

EFI *create_efi(int m)
{     EFI *efi;
      if (m < 1)
         fault("create_efi: invalid order");
      efi = umalloc(sizeof(EFI));
      efi->m = m;
      efi->lu = create_lu(m);
      efi->eta = create_eta(m);
      efi->col = ucalloc(1+m, sizeof(double));
      efi->flag = 0;
      efi->work = ucalloc(1+m, sizeof(double));
      return efi;
}

/* eof */
