/* glpset/urand.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stdlib.h>
#include "glpset.h"

/*----------------------------------------------------------------------
-- urand -- uniform pseudo-random number generator.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- double urand(void);
--
-- *Returns*
--
-- The urand routine returns a pseudo-random number which is uniformly
-- distributed in the range [0, 1]. */

double urand(void)
{     /* this implementation can be changed in the future */
      double x;
      x = (double)rand() / (double)RAND_MAX;
      if (x < 0.0) x = 0.0;
      if (x > 1.0) x = 1.0;
      return x;
}

/* eof */
