/* glptext/open_text.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include "glpset.h"
#include "glptext.h"

/*----------------------------------------------------------------------
-- open_text - open text stream.
--
-- *Synopsis*
--
-- #include "glptext.h"
-- TEXT *open_text(char *fname);
--
-- *Description*
--
-- The open_text routine opens a text stream and connects it with an
-- input text file, whose name is the character string fname.
--
-- *Returns*
--
-- If the operation was successful, the routine returns a pointer to
-- the open text stream. Otherwise the routine returns NULL. */

TEXT *open_text(char *fname)
{     TEXT *text;
      FILE *fp;
      fp = fopen(fname, "r");
      if (fp == NULL)
      {  error("open_text: unable to open `%s' - %s", fname,
            strerror(errno));
         return NULL;
      }
      text = umalloc(sizeof(TEXT));
      text->fp = fp;
      text->file = umalloc(strlen(fname)+1);
      strcpy(text->file, fname);
      text->line = 0;
      text->c = '?';
      text->token = T_EOF;
      text->len = 0;
      text->image[0] = '\0';
      text->t_int = 0;
      text->t_real = 0.0;
      text->err = 0;
      return text;
}

/* eof */
