/* glpapi/glp_check_name.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <ctype.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_check_name - check symbolic name for correctness.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_check_name(char *name);
--
-- *Description*
--
-- The routine glp_check_name checks the given symbolic name for
-- correctness.
--
-- Symbolic name is considered as correct if it consists of 1 up to 255
-- graphic characters.
--
-- *Returns*
--
-- If the given symbolic name is correct, the routine returns zero.
-- Otherwise the routine returns non-zero. */

int glp_check_name(char *name)
{     int t;
      for (t = 0; name[t] != '\0'; t++)
         if (t == 255 || !isgraph(name[t])) return 1;
      return 0;
}

/* eof */
