/* glpimg/get_imgval.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpimg.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- get_imgval - get current value of pixel.
--
-- *Synopsis*
--
-- #include "glpimg.h"
-- int get_imgval(IMG *img, int x, int y);
--
-- *Returns*
--
-- The get_imgval routine returns the current value of the pixel of the
-- raster image which has absolute coordinates (x,y). If the pixel (x,y)
-- is out of the image, the routine returns negative value. */

int get_imgval(IMG *img, int x, int y)
{     unsigned char *scan;
      int val = -1;
      if (!(0 <= x && x < img->xsize && 0 <= y && y < img->ysize))
         goto skip;
      switch (img->type)
      {  case IMG_2: /* 2 colors (1 bit per pixel) */
            scan = img->scan + img->len * y + (x >> 3);
            switch (x & 7)
            {  case 0: val = (*scan >> 7) & 1; break;
               case 1: val = (*scan >> 6) & 1; break;
               case 2: val = (*scan >> 5) & 1; break;
               case 3: val = (*scan >> 4) & 1; break;
               case 4: val = (*scan >> 3) & 1; break;
               case 5: val = (*scan >> 2) & 1; break;
               case 6: val = (*scan >> 1) & 1; break;
               case 7: val = (*scan >> 0) & 1; break;
            }
            break;
         case IMG_4: /* 4 colors (2 bits per pixel) */
            scan = img->scan + img->len * y + (x >> 2);
            switch (x & 3)
            {  case 0: val = (*scan >> 6) & 3; break;
               case 1: val = (*scan >> 4) & 3; break;
               case 2: val = (*scan >> 2) & 3; break;
               case 3: val = (*scan >> 0) & 3; break;
            }
            break;
         case IMG_16: /* 16 colors (4 bits per pixel) */
            scan = img->scan + img->len * y + (x >> 1);
            switch (x & 1)
            {  case 0: val = (*scan >> 4) & 15; break;
               case 1: val = (*scan >> 0) & 15; break;
            }
            break;
         case IMG_256: /* 256 colors (8 bits per pixel) */
            scan = img->scan + img->len * y + x;
            val = *scan & 255;
            break;
         default:
            insist(img->type != img->type);
      }
skip: return val;
}

/* eof */
