/* glpimg/set_color.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <assert.h>
#include "glpimg.h"

/*----------------------------------------------------------------------
-- set_color - change current color index.
--
-- *Synopsis*
--
-- #include "glpimg.h"
-- void set_color(IMG *img, int color);
--
-- *Description*
--
-- The set_color routine sets new color index for the raster image as
-- specified by the parameter color. */

void set_color(IMG *img, int color)
{     switch (img->type)
      {  case IMG_2: /* 2 colors (1 bit per pixel) */
            img->color = color & 0x01;
            break;
         case IMG_4: /* 4 colors (2 bits per pixel) */
            img->color = color & 0x03;
            break;
         case IMG_16: /* 16 colors (4 bits per pixel) */
            img->color = color & 0x0F;
            break;
         case IMG_256: /* 256 colors (8 bits per pixel) */
            img->color = color & 0xFF;
            break;
         default:
            assert(img->type != img->type);
      }
      return;
}

/* eof */
