/* glpmat/sort_mat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpmat.h"

/*----------------------------------------------------------------------
-- sort_mat - ordering row and column lists of sparse matrix.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *sort_mat(MAT *A);
--
-- *Description*
--
-- The sort_mat routine sorts row and column linked lists of the matrix
-- A, so in row lists all elements follow in the order of increasing
-- column numbers, and in column lists all elements follow in the order
-- of increasing row numbers.
--
-- *Returns*
--
-- The sort_mat routine returns a pointer to the matrix A. */

MAT *sort_mat(MAT *A)
{     ELEM *e;
      int i, j;
      /* sort elements in row lists */
      for (i = 1; i <= A->m; i++) A->row[i] = NULL;
      for (j = A->n; j >= 1; j--)
         for (e = A->col[j]; e != NULL; e = e->col)
            e->row = A->row[e->i], A->row[e->i] = e;
      /* sort elements in column lists */
      for (j = 1; j <= A->n; j++) A->col[j] = NULL;
      for (i = A->m; i >= 1; i--)
         for (e = A->row[i]; e != NULL; e = e->row)
            e->col = A->col[e->j], A->col[e->j] = e;
      return A;
}

/* eof */
