/* glppfi/create_pfi.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glppfi.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_pfi - create PFI.
--
-- *Synopsis*
--
-- #include "glppfi.h"
-- PFI *create_pfi(int m);
--
-- *Description*
--
-- The create_pfi routine creates PFI for the basis matrix of order m.
-- Initially the created PFI corresponds to the unity matrix.
--
-- *Returns*
--
-- The create_pfi routine returns a pointer to the created PFI. */

PFI *create_pfi(int m)
{     PFI *pfi;
      if (m < 1)
         fault("create_pfi: invalid order");
      pfi = umalloc(sizeof(PFI));
      pfi->m = m;
      pfi->lu = create_lu(m);
      pfi->eta = create_eta(m);
      pfi->col = ucalloc(1+m, sizeof(double));
      pfi->flag = 0;
      pfi->work = ucalloc(1+m, sizeof(double));
      return pfi;
}

/* eof */
